/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.core;

import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class StringUtils {
    private static final String BASIC_OUTER_XML_TAGS_TEMPLATE = "<naive>%s</naive>";
    private static final String PATH_TO_TEXT = "//text()";
    public static final String DOUBLE_WHITESPACE = "\\s\\s";
    public static final String WHITESPACES = "\\s+";
    public static final String SPACE = " ";
    public static final String EMPTY_STRING = "";

    private StringUtils() {
    }

    public static String removeMultipleWhiteSpaces(String input) {
        String buffer = input.trim();
        String result = buffer.replaceAll(DOUBLE_WHITESPACE, SPACE);
        while (!result.equals(buffer)) {
            buffer = result;
            result = buffer.replaceAll(DOUBLE_WHITESPACE, SPACE);
        }
        return result;
    }

    public static String removeWhiteSpaces(String input) {
        return input.replaceAll(WHITESPACES, EMPTY_STRING);
    }

    public static boolean isBlank(String input) {
        return Objects.isNull(input) || input.isBlank();
    }

    public static boolean isEmpty(String input) {
        return Objects.isNull(input) || input.isEmpty();
    }

    public static String replaceWhiteSpacesWithSpace(String str) {
        return str.replaceAll("\\s", SPACE);
    }

    public static boolean isNotEmpty(String string) {
        return !StringUtils.isEmpty(string);
    }

    public static boolean isNotBlank(String string) {
        return !StringUtils.isBlank(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String removeXmlTags(String input) {
        String output = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newDefaultInstance();
        try {
            Document document = StringUtils.createXmlDocumentFromInput(input, documentBuilderFactory);
            NodeList nodeList = StringUtils.getDocumentNodes(document);
            output = StringUtils.textWithoutXmlTags(nodeList);
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            System.out.println(e.getMessage());
        }
        finally {
            if (Objects.isNull(output)) {
                output = input;
            }
        }
        return StringUtils.removeMultipleWhiteSpaces(output).trim();
    }

    private static String textWithoutXmlTags(NodeList nodeList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int counter = 0; counter < nodeList.getLength(); ++counter) {
            stringBuilder.append(EMPTY_STRING).append(nodeList.item(counter).getTextContent());
        }
        return stringBuilder.toString();
    }

    private static NodeList getDocumentNodes(Document document) throws XPathExpressionException {
        XPathFactory xpathFactory = XPathFactory.newDefaultInstance();
        XPath xpath = xpathFactory.newXPath();
        XPathExpression expr = xpath.compile(PATH_TO_TEXT);
        return (NodeList)expr.evaluate(document, XPathConstants.NODESET);
    }

    private static Document createXmlDocumentFromInput(String input, DocumentBuilderFactory documentBuilderFactory) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        try (StringReader reader = new StringReader(StringUtils.wrapInXml(input));){
            InputSource inputSource = new InputSource(reader);
            inputSource.setEncoding(StandardCharsets.UTF_8.name());
            Document document = documentBuilder.parse(inputSource);
            document.getDocumentElement().normalize();
            Document document2 = document;
            return document2;
        }
    }

    private static String wrapInXml(String input) {
        return String.format(BASIC_OUTER_XML_TAGS_TEMPLATE, input);
    }
}

