/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.core.paths;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.StringUtils;

public final class UnixPath {
    public static final UnixPath EMPTY_PATH = new UnixPath(Collections.emptyList());
    public static final String ROOT = "/";
    public static final UnixPath ROOT_PATH = UnixPath.of("/");
    public static final String PATH_DELIMITER = "/";
    private static final String EMPTY_STRING = "";
    private final List<String> path;

    private UnixPath(List<String> path) {
        this.path = path;
    }

    public static UnixPath of(String ... path) {
        Stream<String> pathElements = UnixPath.extractAllPathElements(path);
        List<String> pathElementsList = UnixPath.addRootIfPresentInOriginalPath(pathElements, path).collect(Collectors.toList());
        return UnixPath.pathIsEmpty(pathElementsList) ? EMPTY_PATH : new UnixPath(pathElementsList);
    }

    @JsonCreator
    public static UnixPath fromString(String childPath) {
        return UnixPath.of(childPath);
    }

    public boolean isRoot() {
        return this.equals(ROOT_PATH);
    }

    public Optional<UnixPath> getParent() {
        return this.path.size() > 1 ? Optional.of(new UnixPath(this.path.subList(0, this.lastPathElementIndex()))) : Optional.empty();
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnixPath)) {
            return false;
        }
        UnixPath unixPath = (UnixPath)o;
        return Objects.equals(this.path, unixPath.path);
    }

    @JsonValue
    public String toString() {
        if (UnixPath.pathIsEmpty(this.path)) {
            return EMPTY_STRING;
        }
        if (this.isAbsolute()) {
            return this.avoidWritingRootPathTwice();
        }
        return this.formatPathAsString(this.path);
    }

    public UnixPath addChild(String childPath) {
        return this.addChild(UnixPath.of(childPath));
    }

    public UnixPath addChild(UnixPath childPath) {
        ArrayList<String> newPathArray = new ArrayList<String>();
        newPathArray.addAll(this.path);
        newPathArray.addAll(childPath.path);
        return UnixPath.of((String[])newPathArray.toArray(String[]::new));
    }

    public String getLastPathElement() {
        return this.path.get(this.lastPathElementIndex());
    }

    public String getPathElementByIndexFromEnd(int index) {
        return this.getPathElementByIndex(this.lastPathElementIndex() - index);
    }

    @Deprecated(since="getLastPathElement was introduced")
    @JacocoGenerated
    public String getFilename() {
        return this.getLastPathElement();
    }

    public UnixPath addRoot() {
        return this.isAbsolute() ? this : ROOT_PATH.addChild(this);
    }

    public UnixPath removeRoot() {
        return this.isAbsolute() ? new UnixPath(this.path.subList(1, this.path.size())) : this;
    }

    public boolean isEmptyPath() {
        return UnixPath.pathIsEmpty(this.path);
    }

    public UnixPath replacePathElementByIndexFromEnd(int index, String replacement) {
        if (this.isRoot() || this.isEmptyPath() || this.path.size() <= index) {
            return this;
        }
        ArrayList<String> newPath = new ArrayList<String>(this.path);
        newPath.set(this.lastPathElementIndex() - index, replacement);
        return new UnixPath(newPath);
    }

    private static Stream<String> prependRoot(Stream<String> pathElements) {
        return Stream.concat(Stream.of("/"), pathElements);
    }

    private static Stream<String> extractAllPathElements(String ... path) {
        Stream<String> nonNullPathElements = UnixPath.discardNullArrayElements(path);
        return UnixPath.splitInputElementsContainingPathDelimiter(nonNullPathElements);
    }

    private static Stream<String> splitInputElementsContainingPathDelimiter(Stream<String> pathElements) {
        return pathElements.map(UnixPath::splitCompositePathElements).flatMap(Arrays::stream).filter(StringUtils::isNotBlank);
    }

    private static Stream<String> discardNullArrayElements(String ... path) {
        return Optional.ofNullable(path).stream().flatMap(Arrays::stream).filter(Objects::nonNull);
    }

    private static String[] splitCompositePathElements(String pathElement) {
        return pathElement.split("/");
    }

    private static Stream<String> addRootIfPresentInOriginalPath(Stream<String> pathElements, String ... path) {
        return UnixPath.pathBeginsWithRoot(path) ? UnixPath.prependRoot(pathElements) : pathElements;
    }

    private static boolean pathBeginsWithRoot(String ... path) {
        return Objects.nonNull(path) && path.length > 0 && Objects.nonNull(path[0]) && path[0].startsWith("/");
    }

    private static boolean pathIsEmpty(List<String> path) {
        return Objects.isNull(path) || path.isEmpty();
    }

    private String getPathElementByIndex(int index) {
        return this.path.get(index);
    }

    private boolean isAbsolute() {
        return !this.isEmptyPath() && "/".equals(this.path.get(0));
    }

    private String formatPathAsString(List<String> pathArray) {
        return String.join((CharSequence)"/", pathArray);
    }

    private int lastPathElementIndex() {
        return this.path.size() - 1;
    }

    private String avoidWritingRootPathTwice() {
        return "/" + this.formatPathAsString(this.path.subList(1, this.path.size()));
    }
}

