/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.doi;

import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.attempt.Try;
import nva.commons.doi.InvalidDoiException;
import nva.commons.doi.UnitHttpClient;
import nva.commons.doi.UnresolvableDoiException;
import org.apache.commons.validator.routines.UrlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoiValidator {
    private static final String DOI_URL_REGEX_START = "^https?://(?:dx\\.)?doi\\.org/";
    private static final String DOI_STRING_REGEX_START = "^([^/]+:)?";
    public static final String DOI_SUFFIX_REGEX = "10\\.\\d{4,9}/\\S+$";
    public static final Pattern DOI_URL_PATTERN = Pattern.compile("^https?://(?:dx\\.)?doi\\.org/10\\.\\d{4,9}/\\S+$", 2);
    public static final Pattern DOI_STRING_PATTERN = Pattern.compile("^([^/]+:)?10\\.\\d{4,9}/\\S+$", 2);
    public static final String INVALID_DOI_ERROR = "Invalid DOI";
    private static final Logger logger = LoggerFactory.getLogger(DoiValidator.class);
    private final UnitHttpClient httpClient;

    @JacocoGenerated
    public DoiValidator() {
        this(new UnitHttpClient());
    }

    public DoiValidator(UnitHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public static Boolean validateOrThrow(String doi) {
        if (DoiValidator.validateOffline(doi)) {
            return true;
        }
        logger.error(INVALID_DOI_ERROR + doi);
        throw new InvalidDoiException(doi);
    }

    public static boolean validateOffline(String doi) {
        if (Objects.isNull(doi)) {
            return false;
        }
        Matcher urlMatcher = DOI_URL_PATTERN.matcher(doi);
        Matcher stringMatcher = DOI_STRING_PATTERN.matcher(doi);
        return urlMatcher.matches() && DoiValidator.isUri(doi) || stringMatcher.matches();
    }

    public static boolean validateOffline(URI doi) {
        return Objects.nonNull(doi) && DoiValidator.validateOffline(doi.toString());
    }

    public Boolean validateOnline(URI doi) {
        HttpResponse<String> httpResponse = this.resolve(doi);
        if (DoiValidator.doiHasBeenResolved(httpResponse).booleanValue()) {
            return true;
        }
        throw new UnresolvableDoiException(DoiValidator.responseToString(httpResponse));
    }

    private static boolean isUri(String uri) {
        return UrlValidator.getInstance().isValid(uri);
    }

    private static Boolean doiHasBeenResolved(HttpResponse<String> response) {
        int statusCode = response.statusCode();
        return statusCode == 302 || statusCode == 301 || statusCode == 304 || statusCode == 200;
    }

    private static String responseToString(HttpResponse<String> response) {
        return String.format("ResponseStatusCode:%s, ResponseBody:%s", response.statusCode(), response.body());
    }

    private HttpResponse<String> resolve(URI doi) {
        return (HttpResponse)Try.attempt(() -> this.resolveAsync(doi).get()).orElseThrow();
    }

    private CompletableFuture<HttpResponse<String>> resolveAsync(URI doi) {
        HttpRequest.Builder getRequest = HttpRequest.newBuilder(doi).method("HEAD", HttpRequest.BodyPublishers.noBody());
        return this.httpClient.sendAsync(getRequest, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
    }
}

