/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.instancetypes.journal;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import no.unit.nva.model.instancetypes.PeerReviewedPaper;
import no.unit.nva.model.pages.Range;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class JournalArticle
extends PeerReviewedPaper {
    private String volume;
    private String issue;
    private String articleNumber;

    @JacocoGenerated
    public JournalArticle() {
    }

    private JournalArticle(Builder builder) {
        this.setVolume(builder.volume);
        this.setIssue(builder.issue);
        this.setArticleNumber(builder.articleNumber);
        this.setPages(builder.pages);
        this.setPeerReviewed(builder.peerReviewed);
    }

    public String getVolume() {
        return this.volume;
    }

    public void setVolume(String volume) {
        this.volume = volume;
    }

    public String getIssue() {
        return this.issue;
    }

    public void setIssue(String issue) {
        this.issue = issue;
    }

    public String getArticleNumber() {
        return this.articleNumber;
    }

    public void setArticleNumber(String articleNumber) {
        this.articleNumber = articleNumber;
    }

    @Override
    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JournalArticle)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JournalArticle that = (JournalArticle)o;
        return Objects.equals(this.getVolume(), that.getVolume()) && Objects.equals(this.getIssue(), that.getIssue()) && Objects.equals(this.getArticleNumber(), that.getArticleNumber());
    }

    @Override
    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getVolume(), this.getIssue(), this.getArticleNumber());
    }

    public static final class Builder {
        private String volume;
        private String issue;
        private String articleNumber;
        private Range pages;
        private boolean peerReviewed;

        public Builder withVolume(String volume) {
            this.volume = volume;
            return this;
        }

        public Builder withIssue(String issue) {
            this.issue = issue;
            return this;
        }

        public Builder withArticleNumber(String articleNumber) {
            this.articleNumber = articleNumber;
            return this;
        }

        public Builder withPages(Range pages) {
            this.pages = pages;
            return this;
        }

        public Builder withPeerReviewed(boolean peerReviewed) {
            this.peerReviewed = peerReviewed;
            return this;
        }

        public JournalArticle build() {
            return new JournalArticle(this);
        }
    }
}

