/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.contexttypes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import no.unit.nva.model.contexttypes.LinkedContext;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class Cartograph
implements LinkedContext {
    public static final String ERROR_TEMPLATE = "The URI <%s> is an invalid context for a Cartograph";
    private URI linkedContext;

    @JsonCreator
    public Cartograph(@JsonProperty(value="linkedContext") URI linkedContext) {
        this.linkedContext = linkedContext;
    }

    private Cartograph(Builder builder) {
        this(builder.linkedContext);
    }

    @Override
    public URI getLinkedContext() {
        return this.linkedContext;
    }

    @Override
    public void setLinkedContext(String linkedContext) {
        try {
            this.linkedContext = new URL(linkedContext).toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException(String.format(ERROR_TEMPLATE, linkedContext));
        }
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cartograph)) {
            return false;
        }
        Cartograph that = (Cartograph)o;
        return Objects.equals(this.getLinkedContext(), that.getLinkedContext());
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getLinkedContext());
    }

    public static final class Builder {
        private URI linkedContext;

        public Builder withLinkedContext(URI linkedContext) {
            this.linkedContext = linkedContext;
            return this;
        }

        public Cartograph build() {
            return new Cartograph(this);
        }
    }
}

