/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.instancetypes.musicalcontent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import no.unit.nva.model.instancetypes.NonPeerReviewedPaper;
import no.unit.nva.model.instancetypes.musicalcontent.Ismn;
import no.unit.nva.model.instancetypes.musicalcontent.exception.InvalidIsmnException;
import no.unit.nva.model.pages.Range;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class MusicNotation
extends NonPeerReviewedPaper {
    private final Ismn ismn;

    @JsonCreator
    public MusicNotation(@JsonProperty(value="pages") Range pages, @JsonProperty(value="ismn") String ismn) throws InvalidIsmnException {
        super(pages);
        this.ismn = Objects.nonNull(ismn) ? new Ismn(ismn) : null;
    }

    private MusicNotation(Builder builder) throws InvalidIsmnException {
        this(builder.pages, builder.ismn);
    }

    public String getIsmn() {
        return Objects.nonNull(this.ismn) ? this.ismn.raw() : null;
    }

    public String getFormattedIsmn() {
        return Objects.nonNull(this.ismn) ? this.ismn.formatted() : null;
    }

    public static final class Builder {
        private String ismn;
        private Range pages;

        public Builder withIsmn(String ismn) {
            this.ismn = ismn;
            return this;
        }

        public Builder withPages(Range pages) {
            this.pages = pages;
            return this;
        }

        public MusicNotation build() throws InvalidIsmnException {
            return new MusicNotation(this);
        }
    }
}

