/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import no.unit.nva.model.License;
import no.unit.nva.model.exceptions.MissingLicenseException;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class File {
    public static final String MISSING_LICENSE = "The file is not annotated as an administrative agreement and should have a license";
    private final UUID identifier;
    private final String name;
    private final String mimeType;
    private final Long size;
    private final License license;
    private final boolean administrativeAgreement;
    private final boolean publisherAuthority;
    private final Instant embargoDate;

    @JsonCreator
    public File(@JsonProperty(value="identifier") UUID identifier, @JsonProperty(value="name") String name, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="size") Long size, @JsonProperty(value="license") License license, @JsonProperty(value="administrativeAgreement") boolean administrativeAgreement, @JsonProperty(value="publisherAuthority") boolean publisherAuthority, @JsonProperty(value="embargoDate") Instant embargoDate) {
        this.identifier = identifier;
        this.name = name;
        this.mimeType = mimeType;
        this.size = size;
        this.license = license;
        this.administrativeAgreement = administrativeAgreement;
        this.publisherAuthority = publisherAuthority;
        this.embargoDate = embargoDate;
    }

    public void validate() {
        if (!this.administrativeAgreement && Objects.isNull(this.license)) {
            throw new MissingLicenseException(MISSING_LICENSE);
        }
    }

    private File(Builder builder) {
        this(builder.identifier, builder.name, builder.mimeType, builder.size, builder.license, builder.administrativeAgreement, builder.publisherAuthority, builder.embargoDate);
    }

    public UUID getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Long getSize() {
        return this.size;
    }

    public License getLicense() {
        return this.license;
    }

    public boolean isAdministrativeAgreement() {
        return this.administrativeAgreement;
    }

    public boolean isPublisherAuthority() {
        return this.publisherAuthority;
    }

    public Instant getEmbargoDate() {
        return this.embargoDate;
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof File)) {
            return false;
        }
        File file = (File)o;
        return this.isAdministrativeAgreement() == file.isAdministrativeAgreement() && this.isPublisherAuthority() == file.isPublisherAuthority() && Objects.equals(this.getIdentifier(), file.getIdentifier()) && Objects.equals(this.getName(), file.getName()) && Objects.equals(this.getMimeType(), file.getMimeType()) && Objects.equals(this.getSize(), file.getSize()) && Objects.equals(this.getLicense(), file.getLicense()) && Objects.equals(this.getEmbargoDate(), file.getEmbargoDate());
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getIdentifier(), this.getName(), this.getMimeType(), this.getSize(), this.getLicense(), this.isAdministrativeAgreement(), this.isPublisherAuthority(), this.getEmbargoDate());
    }

    public static final class Builder {
        public boolean administrativeAgreement;
        public boolean publisherAuthority;
        public Instant embargoDate;
        private UUID identifier;
        private String name;
        private String mimeType;
        private Long size;
        private License license;

        public Builder withIdentifier(UUID identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withMimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder withSize(Long size) {
            this.size = size;
            return this;
        }

        public Builder withLicense(License license) {
            this.license = license;
            return this;
        }

        public Builder withAdministrativeAgreement(boolean administrativeAgreement) {
            this.administrativeAgreement = administrativeAgreement;
            return this;
        }

        public Builder withPublisherAuthority(boolean publisherAuthority) {
            this.publisherAuthority = publisherAuthority;
            return this;
        }

        public Builder withEmbargoDate(Instant embargoDate) {
            this.embargoDate = embargoDate;
            return this;
        }

        public File build() {
            return new File(this);
        }
    }
}

