/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.instancetypes.journal;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import no.unit.nva.model.instancetypes.PeerReviewedPaper;
import no.unit.nva.model.instancetypes.journal.JournalArticleContentType;
import no.unit.nva.model.pages.Range;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class JournalArticle
extends PeerReviewedPaper {
    private String volume;
    private String issue;
    private String articleNumber;
    private JournalArticleContentType content;

    @JacocoGenerated
    public JournalArticle() {
    }

    private JournalArticle(Builder builder) {
        this.setVolume(builder.volume);
        this.setIssue(builder.issue);
        this.setArticleNumber(builder.articleNumber);
        this.setPages(builder.pages);
        this.setPeerReviewed(builder.peerReviewed);
        this.setContent(builder.content);
        this.setOriginalResearch(builder.originalResearch);
    }

    public String getVolume() {
        return this.volume;
    }

    public void setVolume(String volume) {
        this.volume = volume;
    }

    public String getIssue() {
        return this.issue;
    }

    public void setIssue(String issue) {
        this.issue = issue;
    }

    public String getArticleNumber() {
        return this.articleNumber;
    }

    public void setArticleNumber(String articleNumber) {
        this.articleNumber = articleNumber;
    }

    public JournalArticleContentType getContent() {
        return this.content;
    }

    public void setContent(JournalArticleContentType content) {
        this.content = content;
    }

    public void setOriginalResearch(boolean originalResearch) {
        if (this.isOriginalResearchCandidate()) {
            this.originalResearch = originalResearch;
        }
    }

    private boolean isOriginalResearchCandidate() {
        return this.content == null || this.content == JournalArticleContentType.RESEARCH_ARTICLE || this.content == JournalArticleContentType.REVIEW_ARTICLE;
    }

    @Override
    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JournalArticle)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JournalArticle that = (JournalArticle)o;
        return Objects.equals(this.getVolume(), that.getVolume()) && Objects.equals(this.getIssue(), that.getIssue()) && Objects.equals(this.getArticleNumber(), that.getArticleNumber()) && Objects.equals((Object)this.getContent(), (Object)that.getContent()) && this.isOriginalResearch() == that.isOriginalResearch();
    }

    @Override
    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getVolume(), this.getIssue(), this.getArticleNumber(), this.getContent()});
    }

    public static final class Builder {
        private String volume;
        private String issue;
        private String articleNumber;
        private Range pages;
        private boolean peerReviewed;
        private JournalArticleContentType content;
        private boolean originalResearch;

        public Builder withVolume(String volume) {
            this.volume = volume;
            return this;
        }

        public Builder withIssue(String issue) {
            this.issue = issue;
            return this;
        }

        public Builder withArticleNumber(String articleNumber) {
            this.articleNumber = articleNumber;
            return this;
        }

        public Builder withPages(Range pages) {
            this.pages = pages;
            return this;
        }

        public Builder withPeerReviewed(boolean peerReviewed) {
            this.peerReviewed = peerReviewed;
            return this;
        }

        public Builder withContent(JournalArticleContentType content) {
            this.content = content;
            return this;
        }

        public Builder withOriginalResearch(boolean originalResearch) {
            this.originalResearch = originalResearch;
            return this;
        }

        public JournalArticle build() {
            return new JournalArticle(this);
        }
    }
}

