/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.instancetypes.musicalcontent;

import com.fasterxml.jackson.annotation.JsonGetter;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import no.unit.nva.model.instancetypes.musicalcontent.exception.InvalidIsmnException;
import nva.commons.core.SingletonCollector;
import nva.commons.core.attempt.Try;

public class Ismn {
    private static final List<Character> VALID_MUMERICS = List.of(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'));
    public static final Map<String, Integer> REGISTRANTS = Map.of("0", 4, "1", 5, "2", 5, "3", 5, "4", 6, "5", 6, "6", 6, "7", 7, "8", 7, "9", 8);
    public static final Set<Character> validDelimiters = Set.of(Character.valueOf(' '), Character.valueOf('-'));
    public static final String FORMATTED_ISMN_TEMPLATE = "%s-%s-%s-%s";
    public static final String INVALID_ISMN_TEMPLATE = "The ISMN %s is invalid";
    public static final int EVEN_MULTIPLIER = 3;
    public static final int ODD_MULTIPLIER = 1;
    public static final char ISMN_10_PREFIX = 'M';
    public static final int UNSET = -1;
    public static final int PREFIX_CALCULATED_DEFAULT = 39;
    public static final int REGISTRANT_ITEM_LENGTH = 8;
    public static final int STARTING_STATE = 0;
    private Prefix prefix;
    private String publisherId;
    private String itemId;
    private String checkBit;

    public Ismn(String ismn) throws InvalidIsmnException {
        if (Objects.isNull(ismn)) {
            return;
        }
        this.extractIsmnParts(ismn, ismn.toUpperCase(Locale.ENGLISH));
    }

    @JsonGetter
    public String raw() {
        return this.prefix.prefix + this.publisherId + this.itemId + this.checkBit;
    }

    @JsonGetter
    public String formatted() {
        return String.format(FORMATTED_ISMN_TEMPLATE, this.prefix.formattedPrefix, this.publisherId, this.itemId, this.checkBit);
    }

    private void extractIsmnParts(String ismn, String candidate) throws InvalidIsmnException {
        Prefix prefix = null;
        StringBuilder registrant = new StringBuilder();
        StringBuilder item = new StringBuilder();
        int checkBit = -1;
        int checksum = 0;
        StringBuilder parsedPart = new StringBuilder();
        int itemStart = -1;
        for (int count = 0; count < candidate.length(); ++count) {
            char current = candidate.charAt(count);
            if (this.isIrrelevant(count, current)) continue;
            parsedPart.append(current);
            if (this.isPrefixEnd(parsedPart, prefix, current)) {
                try {
                    prefix = Prefix.find(parsedPart.toString());
                    checksum = 39;
                    continue;
                }
                catch (IllegalArgumentException e) {
                    Ismn.throwInvalidIsmnException(ismn);
                }
            }
            if (this.isIncompletePrefix(parsedPart, prefix)) continue;
            checkBit = this.getCheckBit(prefix, registrant, item, current);
            checksum = this.updateChecksum(checksum, parsedPart, Character.getNumericValue(current), checkBit);
            if (this.isPublisherIdPart(parsedPart, prefix, itemStart = this.getItemStart(prefix, registrant, itemStart, current))) {
                registrant.append(current);
                continue;
            }
            if (this.isItemPart(registrant, item)) {
                item.append(current);
                continue;
            }
            if (Ismn.calculateModuloTenDifference(checksum) == checkBit) continue;
            Ismn.throwInvalidIsmnException(ismn);
        }
        this.applyIsmn(ismn, prefix, registrant.toString(), item.toString(), checkBit);
    }

    private int getItemStart(Prefix prefix, StringBuilder registrant, int itemStart, char current) {
        if (itemStart == -1 && Objects.nonNull((Object)prefix) && this.isPublisherIdStart(prefix, registrant)) {
            return REGISTRANTS.get(String.valueOf(current));
        }
        return itemStart;
    }

    private boolean isIrrelevant(int count, char current) {
        return this.isFormattingCharacter(current) || this.isInvalidCharacter(count, current);
    }

    private boolean isInvalidCharacter(int count, char character) {
        return (count != 0 || character != 'M') && !VALID_MUMERICS.contains(Character.valueOf(character));
    }

    private int getCheckBit(Prefix prefix, StringBuilder registrant, StringBuilder item, char current) {
        if (this.isCheckBit(prefix, registrant, item)) {
            return Character.getNumericValue(current);
        }
        return -1;
    }

    private int updateChecksum(int checksum, StringBuilder parsedPart, int charAsInt, int checkBit) {
        if (checkBit == -1) {
            return Ismn.isEven(this.calculateParsedPartLogicalLength(parsedPart.toString())) ? checksum + 3 * charAsInt : checksum + 1 * charAsInt;
        }
        return checksum;
    }

    private boolean isItemPart(StringBuilder registrant, StringBuilder item) {
        return registrant.length() + item.length() < 8;
    }

    private boolean isPublisherIdPart(StringBuilder parsedPart, Prefix prefix, Integer itemStart) {
        return itemStart != -1 && parsedPart.length() - prefix.getLength() < itemStart;
    }

    private boolean isPublisherIdStart(Prefix prefix, StringBuilder registrant) {
        return Objects.nonNull((Object)prefix) && registrant.length() == 0;
    }

    private boolean isCheckBit(Prefix prefix, StringBuilder registrant, StringBuilder item) {
        return Objects.nonNull((Object)prefix) && registrant.length() + item.length() == 8;
    }

    private boolean isIncompletePrefix(StringBuilder parsedPart, Prefix prefix) {
        return Objects.isNull((Object)prefix) && parsedPart.length() < Prefix.ISMN13.getLength();
    }

    private boolean isPrefixEnd(StringBuilder parsedPart, Prefix prefix, char current) {
        return Objects.isNull((Object)prefix) && (current == 'M' || parsedPart.length() == Prefix.ISMN13.getLength());
    }

    private boolean isFormattingCharacter(char current) {
        return validDelimiters.contains(Character.valueOf(current));
    }

    private void applyIsmn(String ismn, Prefix prefix, String registrant, String item, int checkBit) throws InvalidIsmnException {
        if (checkBit == -1) {
            Ismn.throwInvalidIsmnException(ismn);
        } else {
            this.prefix = prefix;
            this.publisherId = registrant;
            this.itemId = item;
            this.checkBit = String.valueOf(checkBit);
        }
    }

    private int calculateParsedPartLogicalLength(String parsedPart) {
        int length = parsedPart.length();
        return parsedPart.startsWith(String.valueOf('M')) ? this.compensateForIsmn10Prefix(length) : length;
    }

    private int compensateForIsmn10Prefix(int length) {
        return length - 1 + Prefix.ISMN13.getLength();
    }

    private static boolean isEven(int counter) {
        return counter % 2 == 0;
    }

    private static int calculateModuloTenDifference(int sum) {
        int modulo = sum % 10;
        return modulo != 0 ? 10 - modulo : 0;
    }

    private static void throwInvalidIsmnException(String candidate) throws InvalidIsmnException {
        throw new InvalidIsmnException(String.format(INVALID_ISMN_TEMPLATE, candidate));
    }

    protected static enum Prefix {
        ISMN10(1, "M", "M"),
        ISMN13(4, "9790", "979-0");

        private final int length;
        private final String prefix;
        private final String formattedPrefix;

        private Prefix(int length, String prefix, String formattedPrefix) {
            this.length = length;
            this.prefix = prefix;
            this.formattedPrefix = formattedPrefix;
        }

        public static Prefix find(String prefix) {
            Try attempt = (Try)Arrays.stream(Prefix.values()).filter(p -> p.prefix.equals(prefix)).collect(SingletonCollector.tryCollect());
            if (attempt.isSuccess()) {
                return (Prefix)((Object)attempt.get());
            }
            throw new IllegalArgumentException("Invalid ISMN prefix: " + prefix);
        }

        private int getLength() {
            return this.length;
        }

        public String getString() {
            return this.prefix;
        }
    }
}

