/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.contexttypes;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import no.unit.nva.model.Level;
import no.unit.nva.model.contexttypes.BasicContext;
import no.unit.nva.model.contexttypes.LinkedContext;
import no.unit.nva.model.exceptions.InvalidIsbnException;
import nva.commons.core.JacocoGenerated;
import org.apache.commons.validator.routines.ISBNValidator;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class Book
implements BasicContext,
LinkedContext {
    private String seriesTitle;
    private String seriesNumber;
    private String publisher;
    private Level level;
    private boolean openAccess;
    private boolean peerReviewed;
    private URL url;
    private List<String> isbnList;
    public static final ISBNValidator ISBN_VALIDATOR = new ISBNValidator();
    private URI linkedContext;

    public Book() {
    }

    private Book(Builder builder) throws InvalidIsbnException {
        this.setSeriesTitle(builder.seriesTitle);
        this.setSeriesNumber(builder.seriesNumber);
        this.setPublisher(builder.publisher);
        this.setLevel(builder.level);
        this.setOpenAccess(builder.openAccess);
        this.setPeerReviewed(builder.peerReviewed);
        this.setUrl(builder.url);
        this.setIsbnList(builder.isbnList);
        this.setLinkedContextURI(builder.linkedContext);
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(Level level) {
        this.level = level;
    }

    @Override
    public boolean isOpenAccess() {
        return this.openAccess;
    }

    @Override
    public void setOpenAccess(boolean openAccess) {
        this.openAccess = openAccess;
    }

    @Override
    public boolean isPeerReviewed() {
        return this.peerReviewed;
    }

    @Override
    public void setPeerReviewed(boolean peerReviewed) {
        this.peerReviewed = peerReviewed;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(URL url) {
        this.url = url;
    }

    public List<String> getIsbnList() {
        return Objects.nonNull(this.isbnList) ? this.isbnList : Collections.emptyList();
    }

    public void setIsbnList(List<String> isbnList) throws InvalidIsbnException {
        if (Objects.isNull(isbnList) || isbnList.isEmpty()) {
            this.isbnList = Collections.emptyList();
            return;
        }
        List validIsbns = isbnList.stream().map(arg_0 -> ((ISBNValidator)ISBN_VALIDATOR).validate(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (isbnList.size() != validIsbns.size()) {
            ArrayList<String> errors = new ArrayList<String>(isbnList);
            errors.removeAll(validIsbns);
            throw new InvalidIsbnException(errors);
        }
        this.isbnList = validIsbns;
    }

    public String getSeriesTitle() {
        return this.seriesTitle;
    }

    public void setSeriesTitle(String seriesTitle) {
        this.seriesTitle = seriesTitle;
    }

    public String getSeriesNumber() {
        return this.seriesNumber;
    }

    public void setSeriesNumber(String seriesNumber) {
        this.seriesNumber = seriesNumber;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    @Override
    public URI getLinkedContext() {
        return this.linkedContext;
    }

    @Override
    public void setLinkedContext(String linkedContext) {
        this.setLinkedContextURI(URI.create(linkedContext));
    }

    protected void setLinkedContextURI(URI linkedContext) {
        this.linkedContext = linkedContext;
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Book)) {
            return false;
        }
        Book book = (Book)o;
        return this.isOpenAccess() == book.isOpenAccess() && this.isPeerReviewed() == book.isPeerReviewed() && Objects.equals(this.getSeriesTitle(), book.getSeriesTitle()) && Objects.equals(this.getSeriesNumber(), book.getSeriesNumber()) && Objects.equals(this.getPublisher(), book.getPublisher()) && this.getLevel() == book.getLevel() && Objects.equals(this.getUrl(), book.getUrl()) && Objects.equals(this.getIsbnList(), book.getIsbnList()) && Objects.equals(this.getLinkedContext(), book.getLinkedContext());
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(new Object[]{this.getSeriesTitle(), this.getSeriesNumber(), this.getPublisher(), this.getLevel(), this.isOpenAccess(), this.isPeerReviewed(), this.getUrl(), this.getIsbnList(), this.getLinkedContext()});
    }

    public static final class Builder {
        private String seriesTitle;
        private String seriesNumber;
        private String publisher;
        private Level level;
        private boolean openAccess;
        private boolean peerReviewed;
        private URL url;
        private List<String> isbnList;
        private URI linkedContext;

        public Builder withSeriesTitle(String seriesTitle) {
            this.seriesTitle = seriesTitle;
            return this;
        }

        public Builder withSeriesNumber(String seriesNumber) {
            this.seriesNumber = seriesNumber;
            return this;
        }

        public Builder withPublisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder withLevel(Level level) {
            this.level = level;
            return this;
        }

        public Builder withOpenAccess(boolean openAccess) {
            this.openAccess = openAccess;
            return this;
        }

        public Builder withPeerReviewed(boolean peerReviewed) {
            this.peerReviewed = peerReviewed;
            return this;
        }

        public Builder withUrl(URL url) {
            this.url = url;
            return this;
        }

        public Builder withIsbnList(List<String> isbnList) {
            this.isbnList = isbnList;
            return this;
        }

        public Builder withLinkedContext(String linkedContext) {
            this.linkedContext = URI.create(linkedContext);
            return this;
        }

        public Book build() throws InvalidIsbnException {
            return new Book(this);
        }
    }
}

