/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.contexttypes;

import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import no.unit.nva.model.Level;
import no.unit.nva.model.contexttypes.BasicContext;
import no.unit.nva.model.contexttypes.Book;
import no.unit.nva.model.contexttypes.SerialPublication;
import no.unit.nva.model.contexttypes.utils.IssnUtil;
import no.unit.nva.model.exceptions.InvalidIsbnException;
import no.unit.nva.model.exceptions.InvalidIssnException;
import nva.commons.core.JacocoGenerated;

public class Report
extends Book
implements SerialPublication,
BasicContext {
    private String printIssn;
    private String onlineIssn;

    public Report() {
    }

    private Report(Builder builder) throws InvalidIssnException, InvalidIsbnException {
        this.setSeriesTitle(builder.seriesTitle);
        this.setSeriesNumber(builder.seriesNumber);
        this.setPublisher(builder.publisher);
        this.setLevel(builder.level);
        this.setOpenAccess(builder.openAccess);
        this.setPeerReviewed(builder.peerReviewed);
        this.setIsbnList(builder.isbnList);
        this.setPrintIssn(builder.printIssn);
        this.setOnlineIssn(builder.onlineIssn);
        this.setUrl(builder.url);
        this.setLinkedContextURI(builder.linkedContext);
    }

    public String getPrintIssn() {
        return this.printIssn;
    }

    @Override
    public void setPrintIssn(String printIssn) throws InvalidIssnException {
        this.printIssn = IssnUtil.checkIssn(printIssn);
    }

    public String getOnlineIssn() {
        return this.onlineIssn;
    }

    @Override
    public void setOnlineIssn(String onlineIssn) throws InvalidIssnException {
        this.onlineIssn = IssnUtil.checkIssn(onlineIssn);
    }

    @Override
    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Report)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Report report = (Report)o;
        return Objects.equals(this.getPrintIssn(), report.getPrintIssn()) && Objects.equals(this.getOnlineIssn(), report.getOnlineIssn());
    }

    @Override
    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getPrintIssn(), this.getOnlineIssn());
    }

    public static final class Builder {
        private String seriesTitle;
        private String seriesNumber;
        private String publisher;
        private Level level;
        private boolean openAccess;
        private boolean peerReviewed;
        private List<String> isbnList;
        private String printIssn;
        private String onlineIssn;
        private URL url;
        private URI linkedContext;

        public Builder withSeriesTitle(String seriesTitle) {
            this.seriesTitle = seriesTitle;
            return this;
        }

        public Builder withSeriesNumber(String seriesNumber) {
            this.seriesNumber = seriesNumber;
            return this;
        }

        public Builder withPublisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder withLevel(Level level) {
            this.level = level;
            return this;
        }

        public Builder withOpenAccess(boolean openAccess) {
            this.openAccess = openAccess;
            return this;
        }

        public Builder withPeerReviewed(boolean peerReviewed) {
            this.peerReviewed = peerReviewed;
            return this;
        }

        public Builder withIsbnList(List<String> isbnList) {
            this.isbnList = isbnList;
            return this;
        }

        public Builder withPrintIssn(String printIssn) {
            this.printIssn = printIssn;
            return this;
        }

        public Builder withOnlineIssn(String onlineIssn) {
            this.onlineIssn = onlineIssn;
            return this;
        }

        public Builder withUrl(URL url) {
            this.url = url;
            return this;
        }

        public Builder withLinkedContext(String linkedContext) {
            this.linkedContext = URI.create(linkedContext);
            return this;
        }

        public Report build() throws InvalidIssnException, InvalidIsbnException {
            return new Report(this);
        }
    }
}

