/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import no.unit.nva.model.DoiRequestMessage;
import no.unit.nva.model.DoiRequestStatus;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class DoiRequest {
    private DoiRequestStatus status;
    private Instant modifiedDate;
    @JsonAlias(value={"date"})
    private Instant createdDate;
    private List<DoiRequestMessage> messages;

    @JacocoGenerated
    public DoiRequest() {
        this.messages = Collections.emptyList();
    }

    private DoiRequest(Builder builder) {
        this.setStatus(builder.status);
        this.setModifiedDate(builder.modifiedDate);
        this.setCreatedDate(builder.createdDate);
        this.setMessages(builder.messages);
    }

    public Instant getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Instant createdDate) {
        this.createdDate = createdDate;
    }

    public Instant getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Instant modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public DoiRequestStatus getStatus() {
        return this.status;
    }

    public void setStatus(DoiRequestStatus status) {
        this.status = status;
    }

    public List<DoiRequestMessage> getMessages() {
        return this.messages;
    }

    public void setMessages(List<DoiRequestMessage> messages) {
        this.messages = messages;
    }

    public Builder copy() {
        return new Builder().withStatus(this.getStatus()).withModifiedDate(this.getModifiedDate()).withCreatedDate(this.getCreatedDate()).withMessages(this.getMessages());
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoiRequest that = (DoiRequest)o;
        return this.getStatus() == that.getStatus() && Objects.equals(this.getModifiedDate(), that.getModifiedDate()) && Objects.equals(this.getCreatedDate(), that.getCreatedDate()) && Objects.equals(this.getMessages(), that.getMessages());
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(new Object[]{this.getStatus(), this.getCreatedDate(), this.getMessages()});
    }

    public static final class Builder {
        private DoiRequestStatus status;
        private Instant modifiedDate;
        private Instant createdDate;
        private List<DoiRequestMessage> messages;

        public Builder() {
            this.messages = Collections.emptyList();
        }

        public Builder(DoiRequest copy) {
            this.status = copy.getStatus();
            this.modifiedDate = copy.getModifiedDate();
            this.createdDate = copy.getCreatedDate();
            this.messages = copy.getMessages();
        }

        public Builder withStatus(DoiRequestStatus status) {
            this.status = status;
            return this;
        }

        public Builder withCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public Builder withModifiedDate(Instant modifiedDate) {
            this.modifiedDate = modifiedDate;
            return this;
        }

        public Builder withMessages(List<DoiRequestMessage> messages) {
            this.messages = messages;
            return this;
        }

        public Builder addMessage(DoiRequestMessage message) {
            this.initializeMessagesIfEmpty();
            this.messages.add(message);
            return this;
        }

        private void initializeMessagesIfEmpty() {
            if (this.messages.isEmpty()) {
                this.messages = new ArrayList<DoiRequestMessage>();
            }
        }

        public DoiRequest build() {
            return new DoiRequest(this);
        }
    }
}

