/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.time.Instant;
import no.unit.nva.DatamodelConfig;
import no.unit.nva.PublicationBase;
import no.unit.nva.WithContext;
import no.unit.nva.WithFile;
import no.unit.nva.WithIdentifier;
import no.unit.nva.WithInternal;
import no.unit.nva.WithMetadata;
import no.unit.nva.api.PublicationContext;
import no.unit.nva.model.Organization;
import no.unit.nva.model.Publication;
import no.unit.nva.model.PublicationStatus;

public final class PublicationMapper {
    private PublicationMapper() {
    }

    public static <REQUEST extends PublicationBase> Publication toExistingPublication(REQUEST request, WithInternal existing) {
        Publication publication = PublicationMapper.toPublication(request);
        PublicationMapper.mapInternal(existing, publication);
        Instant now = Instant.now();
        publication.setModifiedDate(now);
        return publication;
    }

    public static <REQUEST extends PublicationBase> Publication toNewPublication(REQUEST request, String owner, URI handle, URI link, Organization publisher) {
        Publication publication = PublicationMapper.toPublication(request);
        Instant now = Instant.now();
        publication.setCreatedDate(now);
        publication.setModifiedDate(now);
        publication.setOwner(owner);
        publication.setHandle(handle);
        publication.setLink(link);
        publication.setPublisher(publisher);
        publication.setStatus(PublicationStatus.DRAFT);
        return publication;
    }

    public static <R extends WithContext> R convertValue(Publication publication, JsonNode context, Class<R> responseType) {
        WithContext response = (WithContext)DatamodelConfig.dataModelObjectMapper.convertValue((Object)publication, responseType);
        response.setContext(context);
        return (R)response;
    }

    public static <R extends WithContext> R convertValue(Publication publication, Class<R> responseType) {
        return PublicationMapper.convertValue(publication, PublicationContext.getContext(), responseType);
    }

    private static <REQUEST extends PublicationBase> Publication toPublication(REQUEST request) {
        Publication publication = new Publication();
        if (request instanceof WithIdentifier) {
            PublicationMapper.mapIdentifier((WithIdentifier)request, publication);
        }
        if (request instanceof WithMetadata) {
            PublicationMapper.mapMetadata((WithMetadata)request, publication);
        }
        if (request instanceof WithFile) {
            PublicationMapper.mapFile((WithFile)request, publication);
        }
        if (request instanceof WithInternal) {
            PublicationMapper.mapInternal((WithInternal)request, publication);
        }
        return publication;
    }

    private static void mapIdentifier(WithIdentifier request, Publication publication) {
        publication.setIdentifier(request.getIdentifier());
    }

    private static void mapMetadata(WithMetadata request, Publication publication) {
        publication.setEntityDescription(request.getEntityDescription());
        publication.setProjects(request.getProjects());
        publication.setSubjects(request.getSubjects());
    }

    private static void mapFile(WithFile request, Publication publication) {
        publication.setFileSet(request.getFileSet());
    }

    private static void mapInternal(WithInternal request, Publication publication) {
        publication.setCreatedDate(request.getCreatedDate());
        publication.setHandle(request.getHandle());
        publication.setIndexedDate(request.getIndexedDate());
        publication.setLink(request.getLink());
        publication.setModifiedDate(request.getModifiedDate());
        publication.setOwner(request.getOwner());
        publication.setPublishedDate(request.getPublishedDate());
        publication.setPublisher(request.getPublisher());
        publication.setStatus(request.getStatus());
        publication.setDoi(request.getDoi());
        publication.setDoiRequest(request.getDoiRequest());
    }
}

