/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import no.unit.nva.WithContext;
import no.unit.nva.WithFile;
import no.unit.nva.WithId;
import no.unit.nva.WithIdentifier;
import no.unit.nva.WithInternal;
import no.unit.nva.WithMetadata;
import no.unit.nva.api.PublicationContext;
import no.unit.nva.file.model.FileSet;
import no.unit.nva.identifiers.SortableIdentifier;
import no.unit.nva.model.DoiRequest;
import no.unit.nva.model.EntityDescription;
import no.unit.nva.model.Organization;
import no.unit.nva.model.Publication;
import no.unit.nva.model.PublicationStatus;
import no.unit.nva.model.ResearchProject;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonTypeName(value="Publication")
public class PublicationResponse
implements WithIdentifier,
WithInternal,
WithMetadata,
WithFile,
WithId,
WithContext {
    private SortableIdentifier identifier;
    private PublicationStatus status;
    private String owner;
    private Organization publisher;
    private Instant createdDate;
    private Instant modifiedDate;
    private Instant publishedDate;
    private Instant indexedDate;
    private URI handle;
    private URI link;
    private EntityDescription entityDescription;
    private FileSet fileSet;
    private URI doi;
    private DoiRequest doiRequest;
    private Boolean doiRequested;
    @JsonProperty(value="@context")
    private JsonNode context;
    private List<ResearchProject> projects;
    private List<URI> subjects;

    public static PublicationResponse fromPublication(Publication publication) {
        PublicationResponse response = new PublicationResponse();
        response.setIdentifier(publication.getIdentifier());
        response.setStatus(publication.getStatus());
        response.setOwner(publication.getOwner());
        response.setPublisher(publication.getPublisher());
        response.setCreatedDate(publication.getCreatedDate());
        response.setModifiedDate(publication.getModifiedDate());
        response.setPublishedDate(publication.getPublishedDate());
        response.setIndexedDate(publication.getIndexedDate());
        response.setHandle(publication.getHandle());
        response.setLink(publication.getLink());
        response.setEntityDescription(publication.getEntityDescription());
        response.setFileSet(publication.getFileSet());
        response.setDoi(publication.getDoi());
        response.setDoiRequest(publication.getDoiRequest());
        response.setProjects(publication.getProjects());
        response.setSubjects(publication.getSubjects());
        response.setContext(PublicationContext.getContext());
        return response;
    }

    @Override
    public FileSet getFileSet() {
        return this.fileSet;
    }

    @Override
    public void setFileSet(FileSet fileSet) {
        this.fileSet = fileSet;
    }

    @Override
    public SortableIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(SortableIdentifier identifier) {
        this.identifier = identifier;
    }

    @Override
    public Instant getCreatedDate() {
        return this.createdDate;
    }

    @Override
    public void setCreatedDate(Instant createdDate) {
        this.createdDate = createdDate;
    }

    @Override
    public PublicationStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(PublicationStatus status) {
        this.status = status;
    }

    @Override
    public URI getHandle() {
        return this.handle;
    }

    @Override
    public void setHandle(URI handle) {
        this.handle = handle;
    }

    @Override
    public Instant getPublishedDate() {
        return this.publishedDate;
    }

    @Override
    public void setPublishedDate(Instant publishedDate) {
        this.publishedDate = publishedDate;
    }

    @Override
    public Instant getModifiedDate() {
        return this.modifiedDate;
    }

    @Override
    public void setModifiedDate(Instant modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public Instant getIndexedDate() {
        return this.indexedDate;
    }

    @Override
    public void setIndexedDate(Instant indexedDate) {
        this.indexedDate = indexedDate;
    }

    @Override
    public URI getLink() {
        return this.link;
    }

    @Override
    public void setLink(URI link) {
        this.link = link;
    }

    @Override
    public Organization getPublisher() {
        return this.publisher;
    }

    @Override
    public void setPublisher(Organization publisher) {
        this.publisher = publisher;
    }

    @Override
    public URI getDoi() {
        return this.doi;
    }

    @Override
    public void setDoi(URI doi) {
        this.doi = doi;
    }

    @Override
    public DoiRequest getDoiRequest() {
        return this.doiRequest;
    }

    @Override
    public void setDoiRequest(DoiRequest doiRequest) {
        this.doiRequest = doiRequest;
        this.doiRequested = Objects.nonNull(doiRequest);
    }

    @Override
    public EntityDescription getEntityDescription() {
        return this.entityDescription;
    }

    @Override
    public void setEntityDescription(EntityDescription entityDescription) {
        this.entityDescription = entityDescription;
    }

    @Override
    public List<ResearchProject> getProjects() {
        return Objects.nonNull(this.projects) ? this.projects : Collections.emptyList();
    }

    @Override
    public void setProjects(List<ResearchProject> projects) {
        this.projects = projects;
    }

    @Override
    public List<URI> getSubjects() {
        return Objects.nonNull(this.subjects) ? this.subjects : Collections.emptyList();
    }

    @Override
    public void setSubjects(List<URI> subjects) {
        this.subjects = subjects;
    }

    public Boolean getDoiRequested() {
        return this.doiRequested;
    }

    @Override
    public JsonNode getContext() {
        return this.context;
    }

    @Override
    public void setContext(JsonNode context) {
        this.context = context;
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(new Object[]{this.getIdentifier(), this.getStatus(), this.getOwner(), this.getPublisher(), this.getCreatedDate(), this.getModifiedDate(), this.getPublishedDate(), this.getIndexedDate(), this.getHandle(), this.getLink(), this.getEntityDescription(), this.getFileSet(), this.getDoi(), this.getDoiRequest(), this.getDoiRequested(), this.getContext(), this.getProjects(), this.getSubjects()});
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublicationResponse)) {
            return false;
        }
        PublicationResponse that = (PublicationResponse)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getIdentifier(), that.getIdentifier()) && this.getStatus() == that.getStatus() && Objects.equals(this.getOwner(), that.getOwner()) && Objects.equals(this.getPublisher(), that.getPublisher()) && Objects.equals(this.getCreatedDate(), that.getCreatedDate()) && Objects.equals(this.getModifiedDate(), that.getModifiedDate()) && Objects.equals(this.getPublishedDate(), that.getPublishedDate()) && Objects.equals(this.getIndexedDate(), that.getIndexedDate()) && Objects.equals(this.getHandle(), that.getHandle()) && Objects.equals(this.getLink(), that.getLink()) && Objects.equals(this.getEntityDescription(), that.getEntityDescription()) && Objects.equals(this.getFileSet(), that.getFileSet()) && Objects.equals(this.getDoi(), that.getDoi()) && Objects.equals(this.getDoiRequest(), that.getDoiRequest()) && Objects.equals(this.getDoiRequested(), that.getDoiRequested()) && Objects.equals(this.getContext(), that.getContext()) && Objects.equals(this.getProjects(), that.getProjects()) && Objects.equals(this.getSubjects(), that.getSubjects());
    }
}

