/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import no.unit.nva.model.Identity;
import no.unit.nva.model.Organization;
import no.unit.nva.model.Role;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class Contributor {
    private final Identity identity;
    private final List<Organization> affiliations;
    private final Role role;
    private final Integer sequence;
    private final boolean correspondingAuthor;

    @JsonCreator
    public Contributor(@JsonProperty(value="identity") Identity identity, @JsonProperty(value="affiliations") List<Organization> affiliations, @JsonProperty(value="role") Role role, @JsonProperty(value="sequence") Integer sequence, @JsonProperty(value="correspondingAuthor") boolean correspondingAuthor) {
        this.identity = identity;
        this.affiliations = affiliations;
        this.role = role;
        this.sequence = sequence;
        this.correspondingAuthor = correspondingAuthor;
    }

    private Contributor(Builder builder) {
        this(builder.identity, builder.affiliations, builder.role, builder.sequence, builder.correspondingAuthor);
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public List<Organization> getAffiliations() {
        return Objects.nonNull(this.affiliations) ? this.affiliations : Collections.emptyList();
    }

    public Integer getSequence() {
        return this.sequence;
    }

    public Role getRole() {
        return this.role;
    }

    public boolean isCorrespondingAuthor() {
        return this.correspondingAuthor;
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(new Object[]{this.getIdentity(), this.getAffiliations(), this.getRole(), this.getSequence(), this.isCorrespondingAuthor()});
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Contributor)) {
            return false;
        }
        Contributor that = (Contributor)o;
        return this.isCorrespondingAuthor() == that.isCorrespondingAuthor() && Objects.equals(this.getIdentity(), that.getIdentity()) && Objects.equals(this.getAffiliations(), that.getAffiliations()) && this.getRole() == that.getRole() && Objects.equals(this.getSequence(), that.getSequence());
    }

    public static final class Builder {
        private Identity identity;
        private List<Organization> affiliations;
        private Role role;
        private Integer sequence;
        private boolean correspondingAuthor;

        public Builder withIdentity(Identity identity) {
            this.identity = identity;
            return this;
        }

        public Builder withAffiliations(List<Organization> affiliations) {
            this.affiliations = affiliations;
            return this;
        }

        public Builder withRole(Role role) {
            this.role = role;
            return this;
        }

        public Builder withSequence(Integer sequence) {
            this.sequence = sequence;
            return this;
        }

        public Builder withCorrespondingAuthor(boolean correspondingAuthor) {
            this.correspondingAuthor = correspondingAuthor;
            return this;
        }

        public Contributor build() {
            return new Contributor(this);
        }
    }
}

