/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.contexttypes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import no.unit.nva.model.contexttypes.Periodical;
import no.unit.nva.model.contexttypes.utils.IssnUtil;
import no.unit.nva.model.exceptions.InvalidIssnException;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class UnconfirmedJournal
implements Periodical {
    private final String title;
    private final String printIssn;
    private final String onlineIssn;

    @JsonCreator
    public UnconfirmedJournal(@JsonProperty(value="title") String title, @JsonProperty(value="printIssn") String printIssn, @JsonProperty(value="onlineIssn") String onlineIssn) throws InvalidIssnException {
        this.title = title;
        this.printIssn = IssnUtil.checkIssn(printIssn);
        this.onlineIssn = IssnUtil.checkIssn(onlineIssn);
    }

    public String getTitle() {
        return this.title;
    }

    public String getPrintIssn() {
        return this.printIssn;
    }

    public String getOnlineIssn() {
        return this.onlineIssn;
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnconfirmedJournal)) {
            return false;
        }
        UnconfirmedJournal that = (UnconfirmedJournal)o;
        return Objects.equals(this.getTitle(), that.getTitle()) && Objects.equals(this.getPrintIssn(), that.getPrintIssn()) && Objects.equals(this.getOnlineIssn(), that.getOnlineIssn());
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getTitle(), this.getPrintIssn(), this.getOnlineIssn());
    }
}

