/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.contexttypes;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import no.unit.nva.model.contexttypes.PublicationContext;
import no.unit.nva.model.contexttypes.media.MediaFormat;
import no.unit.nva.model.contexttypes.media.MediaSubType;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class MediaContribution
implements PublicationContext {
    public static final String MEDIUM = "medium";
    public static final String FORMAT = "format";
    @JsonProperty(value="medium")
    private final MediaSubType medium;
    @JsonProperty(value="format")
    private final MediaFormat format;

    public MediaContribution(@JsonProperty(value="medium") MediaSubType medium, @JsonProperty(value="format") MediaFormat format) {
        this.medium = medium;
        this.format = format;
    }

    public MediaSubType getMedium() {
        return this.medium;
    }

    public MediaFormat getFormat() {
        return this.format;
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(new Object[]{this.getMedium(), this.getFormat()});
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MediaContribution)) {
            return false;
        }
        MediaContribution that = (MediaContribution)o;
        return Objects.equals((Object)this.getMedium(), (Object)that.getMedium()) && Objects.equals((Object)this.getFormat(), (Object)that.getFormat());
    }

    public static final class Builder {
        private MediaSubType medium;
        private MediaFormat format;

        public Builder withMedium(MediaSubType medium) {
            this.medium = medium;
            return this;
        }

        public Builder withFormat(MediaFormat format) {
            this.format = format;
            return this;
        }

        public MediaContribution build() {
            return new MediaContribution(this.medium, this.format);
        }
    }
}

