/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.instancetypes.book;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.stream.Collectors;

public enum BookMonographContentType {
    ACADEMIC_MONOGRAPH("AcademicMonograph", "Academic Monograph"),
    NON_FICTION_MONOGRAPH("NonFictionMonograph", "Non-fiction Monograph"),
    POPULAR_SCIENCE_MONOGRAPH("PopularScienceMonograph", "Popular Science Monograph"),
    TEXTBOOK("Textbook", "Textbook"),
    ENCYCLOPEDIA("Encyclopedia", "Encyclopedia"),
    EXHIBITION_CATALOG("ExhibitionCatalog", "Exhibition catalog");

    public static final String ERROR_MESSAGE_TEMPLATE = "%s not a valid BookMonographContentType, expected one of: %s";
    public static final String DELIMITER = ", ";
    private final String value;
    private final String deprecatedValue;

    private BookMonographContentType(String value, String deprecatedValue) {
        this.value = value;
        this.deprecatedValue = deprecatedValue;
    }

    @JsonCreator
    public static BookMonographContentType lookup(String value) {
        return Arrays.stream(BookMonographContentType.values()).filter(nameType -> BookMonographContentType.equalsCurrentOrDeprecatedValue(value, nameType)).findAny().orElseThrow(() -> new IllegalArgumentException(BookMonographContentType.createErrorMessage(value)));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    private String getDeprecatedValue() {
        return this.deprecatedValue;
    }

    private static boolean equalsCurrentOrDeprecatedValue(String value, BookMonographContentType nameType) {
        return nameType.getValue().equalsIgnoreCase(value) || nameType.getDeprecatedValue().equalsIgnoreCase(value);
    }

    private static String createErrorMessage(String value) {
        return String.format(ERROR_MESSAGE_TEMPLATE, value, Arrays.stream(BookMonographContentType.values()).map(Enum::toString).collect(Collectors.joining(DELIMITER)));
    }
}

