/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.contexttypes.media;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import no.unit.nva.model.contexttypes.media.MediaSubTypeEnum;
import no.unit.nva.model.contexttypes.media.MediaSubTypeOther;
import nva.commons.core.JacocoGenerated;

public class MediaSubType {
    public static final String TYPE = "type";
    @JsonProperty(value="type")
    private final MediaSubTypeEnum type;

    public static MediaSubType createOther(String description) {
        return new MediaSubTypeOther(MediaSubTypeEnum.OTHER, description);
    }

    @JsonCreator
    public static MediaSubType fromJson(@JsonProperty(value="type") MediaSubTypeEnum type, @JsonProperty(value="description") String description) {
        if (MediaSubTypeEnum.OTHER.equals((Object)type)) {
            return MediaSubType.createOther(description);
        }
        return new MediaSubType(type);
    }

    @JsonCreator
    public static MediaSubType fromJsonString(String type) {
        return MediaSubType.create(MediaSubTypeEnum.parse(type));
    }

    public static MediaSubType create(MediaSubTypeEnum type) {
        return new MediaSubType(type);
    }

    protected MediaSubType(MediaSubTypeEnum type) {
        this.type = type;
    }

    public MediaSubTypeEnum getType() {
        return this.type;
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MediaSubType)) {
            return false;
        }
        MediaSubType that = (MediaSubType)o;
        return this.getType() == that.getType();
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(new Object[]{this.getType()});
    }
}

