/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.instancetypes.artistic.music;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import no.unit.nva.model.contexttypes.PublishingHouse;
import no.unit.nva.model.contexttypes.UnconfirmedPublisher;
import no.unit.nva.model.instancetypes.artistic.UnconfirmedPublisherMigrator;
import no.unit.nva.model.instancetypes.artistic.music.Ismn;
import no.unit.nva.model.instancetypes.artistic.music.MusicPerformanceManifestation;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class MusicScore
implements MusicPerformanceManifestation,
UnconfirmedPublisherMigrator {
    public static final String ENSEMBLE_FIELD = "ensemble";
    public static final String MOVEMENTS_FIELD = "movements";
    public static final String EXTENT_FIELD = "extent";
    public static final String PUBLISHER_FIELD = "publisher";
    public static final String ISMN_FIELD = "ismn";
    @JsonProperty(value="ensemble")
    private final String ensemble;
    @JsonProperty(value="movements")
    private final String movements;
    @JsonProperty(value="extent")
    private final String extent;
    @JsonProperty(value="publisher")
    private final PublishingHouse publisher;
    @JsonProperty(value="ismn")
    private final Ismn ismn;

    public MusicScore(@JsonProperty(value="ensemble") String ensemble, @JsonProperty(value="movements") String movements, @JsonProperty(value="extent") String extent, @JsonProperty(value="publisher") PublishingHouse publisher, @JsonProperty(value="ismn") Ismn ismn) {
        this.ensemble = ensemble;
        this.movements = movements;
        this.extent = extent;
        this.publisher = publisher;
        this.ismn = ismn;
    }

    @JsonCreator
    public static MusicScore fromJson(@JsonProperty(value="ensemble") String ensemble, @JsonProperty(value="movements") String movements, @JsonProperty(value="extent") String extent, @JsonProperty(value="publisher") Object publisher, @JsonProperty(value="ismn") Ismn ismn) {
        PublishingHouse publishingHouse = publisher instanceof String ? new UnconfirmedPublisher((String)publisher) : UnconfirmedPublisherMigrator.toPublisher(publisher);
        return new MusicScore(ensemble, movements, extent, publishingHouse, ismn);
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getEnsemble(), this.getMovements(), this.getExtent(), this.getPublisher(), this.getIsmn());
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MusicScore)) {
            return false;
        }
        MusicScore that = (MusicScore)o;
        return Objects.equals(this.getEnsemble(), that.getEnsemble()) && Objects.equals(this.getMovements(), that.getMovements()) && Objects.equals(this.getExtent(), that.getExtent()) && Objects.equals(this.getPublisher(), that.getPublisher()) && Objects.equals(this.getIsmn(), that.getIsmn());
    }

    public String getEnsemble() {
        return this.ensemble;
    }

    public String getMovements() {
        return this.movements;
    }

    public String getExtent() {
        return this.extent;
    }

    public PublishingHouse getPublisher() {
        return this.publisher;
    }

    public Ismn getIsmn() {
        return this.ismn;
    }
}

