/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.instancetypes.journal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import no.unit.nva.model.instancetypes.PublicationInstance;
import no.unit.nva.model.instancetypes.journal.AcademicArticle;
import no.unit.nva.model.instancetypes.journal.AcademicLiteratureReview;
import no.unit.nva.model.instancetypes.journal.CaseReport;
import no.unit.nva.model.instancetypes.journal.JournalArticleContentType;
import no.unit.nva.model.instancetypes.journal.PopularScienceArticle;
import no.unit.nva.model.instancetypes.journal.ProfessionalArticle;
import no.unit.nva.model.instancetypes.journal.StudyProtocol;
import no.unit.nva.model.pages.Range;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class JournalArticle
implements PublicationInstance<Range> {
    public static final String PAGES_FIELD = "pages";
    public static final String TYPE = "type";
    public static final String VOLUME_FIELD = "volume";
    public static final String ISSUE_FIELD = "issue";
    public static final String ARTICLE_NUMBER_FIELD = "articleNumber";
    public static final String CONTENT_TYPE_FIELD = "contentType";
    private final Range pages;
    private final String volume;
    private final String issue;
    private final String articleNumber;

    protected JournalArticle(Range pages, String volume, String issue, String articleNumber) {
        this.pages = pages;
        this.volume = volume;
        this.issue = issue;
        this.articleNumber = articleNumber;
    }

    @JsonCreator
    public static JournalArticle fromJson(@JsonProperty(value="pages") Range pages, @JsonProperty(value="volume") String volume, @JsonProperty(value="issue") String issue, @JsonProperty(value="articleNumber") String articleNumber, @JsonProperty(value="contentType") JournalArticleContentType contentType) {
        if (JournalArticleContentType.ACADEMIC_ARTICLE.equals((Object)contentType)) {
            return new AcademicArticle(pages, volume, issue, articleNumber);
        }
        if (JournalArticleContentType.ACADEMIC_LITERATURE_REVIEW.equals((Object)contentType)) {
            return new AcademicLiteratureReview(pages, volume, issue, articleNumber);
        }
        if (JournalArticleContentType.CASE_REPORT.equals((Object)contentType)) {
            return new CaseReport(pages, volume, issue, articleNumber);
        }
        if (JournalArticleContentType.POPULAR_SCIENCE_ARTICLE.equals((Object)contentType)) {
            return new PopularScienceArticle(pages, volume, issue, articleNumber);
        }
        if (JournalArticleContentType.PROFESSIONAL_ARTICLE.equals((Object)contentType)) {
            return new ProfessionalArticle(pages, volume, issue, articleNumber);
        }
        if (JournalArticleContentType.STUDY_PROTOCOL.equals((Object)contentType)) {
            return new StudyProtocol(pages, volume, issue, articleNumber);
        }
        if (Objects.isNull((Object)contentType)) {
            return new AcademicArticle(pages, volume, issue, articleNumber);
        }
        throw new UnsupportedOperationException("The Journal article subtype is unknown");
    }

    public String getVolume() {
        return this.volume;
    }

    public String getIssue() {
        return this.issue;
    }

    public String getArticleNumber() {
        return this.articleNumber;
    }

    @Override
    public Range getPages() {
        return this.pages;
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JournalArticle)) {
            return false;
        }
        JournalArticle that = (JournalArticle)o;
        return Objects.equals(this.getPages(), that.getPages()) && Objects.equals(this.getVolume(), that.getVolume()) && Objects.equals(this.getIssue(), that.getIssue()) && Objects.equals(this.getArticleNumber(), that.getArticleNumber());
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getPages(), this.getVolume(), this.getIssue(), this.getArticleNumber());
    }
}

