/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.contexttypes.utils;

import java.net.URI;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import no.unit.nva.model.contexttypes.utils.ChannelType;
import nva.commons.core.attempt.Try;
import nva.commons.core.ioutils.IoUtils;
import nva.commons.core.paths.UriWrapper;

@Deprecated
public final class MigrateChannelIdUtil {
    public static final String API_HOST_DEV = "api.dev.nva.aws.unit.no";
    private static final int IDENTIFIER_PATH_INDEX_FROM_END = 1;
    private static final String JOURNAL_ID_MAPPING_FILE = ChannelType.JOURNAL.migrationFileName;
    private static final String SERIES_ID_MAPPING_FILE = ChannelType.SERIES.migrationFileName;
    private static final String PUBLISHER_ID_MAPPING_FILE = ChannelType.PUBLISHER.migrationFileName;
    private static final String BASE_PATH = "publication-channels-v2";
    private static final String CSV_SEPARATOR = ";";
    private static final int NUMBER_OF_COLUMNS = 2;
    private static final int OLD_ID_COLUMN_NUMBER = 0;
    private static final int NEW_ID_COLUMN_NUMBER = 1;
    private static final Map<String, String> journalIdMapping = IoUtils.linesfromResource((Path)Path.of(JOURNAL_ID_MAPPING_FILE, new String[0])).stream().filter(MigrateChannelIdUtil::containsCsvSeparator).map(MigrateChannelIdUtil::splitLineBySeparator).collect(Collectors.toMap(identifierList -> identifierList[0], identifierList -> identifierList[1]));
    private static final Map<String, String> seriesIdMapping = IoUtils.linesfromResource((Path)Path.of(SERIES_ID_MAPPING_FILE, new String[0])).stream().filter(MigrateChannelIdUtil::containsCsvSeparator).map(MigrateChannelIdUtil::splitLineBySeparator).collect(Collectors.toMap(identifierList -> identifierList[0], identifierList -> identifierList[1]));
    private static final Map<String, String> publisherIdMapping = IoUtils.linesfromResource((Path)Path.of(PUBLISHER_ID_MAPPING_FILE, new String[0])).stream().filter(MigrateChannelIdUtil::containsCsvSeparator).map(MigrateChannelIdUtil::splitLineBySeparator).collect(Collectors.toMap(identifierList -> identifierList[0], identifierList -> identifierList[1]));
    private static final int IDENTIFIER_PATH_ELEMENT_INDEX_FROM_END = 1;

    private MigrateChannelIdUtil() {
    }

    @Deprecated
    public static URI migrateToNewIdIfFound(URI id, ChannelType type) {
        String newIdentifier = MigrateChannelIdUtil.getNewIdentifier(id, type);
        String year = UriWrapper.fromUri((URI)id).getPath().getLastPathElement();
        return Objects.nonNull(newIdentifier) ? MigrateChannelIdUtil.constructNewPublicationChannelId(id, year, newIdentifier, type.pathElement) : id;
    }

    @Deprecated
    public static boolean isNewStyleIdentifier(URI id) {
        String identifier = UriWrapper.fromUri((URI)id).getPath().getPathElementByIndexFromEnd(1);
        return Try.attempt(() -> UUID.fromString(identifier)).isSuccess();
    }

    @Deprecated
    public static boolean isNotHostedInDev(URI id) {
        return !MigrateChannelIdUtil.isHostedInDev(id);
    }

    @Deprecated
    private static boolean isHostedInDev(URI id) {
        return API_HOST_DEV.equals(id.getHost());
    }

    private static boolean containsCsvSeparator(String line1) {
        return line1.contains(CSV_SEPARATOR);
    }

    private static String[] splitLineBySeparator(String line) {
        return line.split(CSV_SEPARATOR, 2);
    }

    private static String getNewIdentifier(URI id, ChannelType type) {
        String oldIdentifier = UriWrapper.fromUri((URI)id).getPath().getPathElementByIndexFromEnd(1);
        switch (type) {
            case PUBLISHER: {
                return publisherIdMapping.get(oldIdentifier);
            }
            case SERIES: {
                return seriesIdMapping.get(oldIdentifier);
            }
            case JOURNAL: {
                return journalIdMapping.get(oldIdentifier);
            }
        }
        throw new IllegalArgumentException("Invalid channel type");
    }

    private static URI constructNewPublicationChannelId(URI id, String year, String newIdentifier, String pathElement) {
        return UriWrapper.fromHost((String)id.getHost()).addChild(new String[]{BASE_PATH}).addChild(new String[]{pathElement}).addChild(new String[]{newIdentifier}).addChild(new String[]{year}).getUri();
    }
}

