/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import no.unit.nva.model.AdditionalIdentifier;
import no.unit.nva.model.ContributorVerificationStatus;
import no.unit.nva.model.NameType;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class Identity {
    private URI id;
    private String name;
    private NameType nameType;
    private String orcId;
    private ContributorVerificationStatus verificationStatus;
    private List<AdditionalIdentifier> additionalIdentifiers;

    public Identity() {
    }

    private Identity(Builder builder) {
        this.setId(builder.id);
        this.setName(builder.name);
        this.setNameType(builder.nameType);
        this.setOrcId(builder.orcId);
        this.setVerificationStatus(builder.verificationStatus);
        this.setAdditionalIdentifiers(builder.additionalIdentifiers);
    }

    public URI getId() {
        return this.id;
    }

    public void setId(URI id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NameType getNameType() {
        return this.nameType;
    }

    public void setNameType(NameType nameType) {
        this.nameType = nameType;
    }

    public String getOrcId() {
        return this.orcId;
    }

    public void setOrcId(String orcId) {
        this.orcId = orcId;
    }

    public List<AdditionalIdentifier> getAdditionalIdentifiers() {
        return Objects.nonNull(this.additionalIdentifiers) ? this.additionalIdentifiers : Collections.emptyList();
    }

    public void setAdditionalIdentifiers(List<AdditionalIdentifier> additionalIdentifiers) {
        this.additionalIdentifiers = additionalIdentifiers;
    }

    public ContributorVerificationStatus getVerificationStatus() {
        return this.verificationStatus;
    }

    public void setVerificationStatus(ContributorVerificationStatus verificationStatus) {
        this.verificationStatus = verificationStatus;
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(new Object[]{this.getId(), this.getName(), this.getNameType(), this.getOrcId(), this.getVerificationStatus(), this.getAdditionalIdentifiers()});
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Identity)) {
            return false;
        }
        Identity identity = (Identity)o;
        return Objects.equals(this.getId(), identity.getId()) && Objects.equals(this.getName(), identity.getName()) && this.getNameType() == identity.getNameType() && Objects.equals(this.getOrcId(), identity.getOrcId()) && Objects.equals(this.getAdditionalIdentifiers(), identity.getAdditionalIdentifiers()) && Objects.equals((Object)this.getVerificationStatus(), (Object)identity.getVerificationStatus());
    }

    public static final class Builder {
        private URI id;
        private String name;
        private NameType nameType;
        private String orcId;
        private List<AdditionalIdentifier> additionalIdentifiers;
        private ContributorVerificationStatus verificationStatus;

        public Builder withId(URI id) {
            this.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withNameType(NameType nameType) {
            this.nameType = nameType;
            return this;
        }

        public Builder withOrcId(String orcId) {
            this.orcId = orcId;
            return this;
        }

        public Builder withVerificationStatus(ContributorVerificationStatus verificationStatus) {
            this.verificationStatus = verificationStatus;
            return this;
        }

        public Builder withAdditionalIdentifiers(List<AdditionalIdentifier> additionalIdentifiers) {
            this.additionalIdentifiers = additionalIdentifiers;
            return this;
        }

        public Identity build() {
            return new Identity(this);
        }
    }
}

