/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.stream.Collectors;

public enum Revision {
    REVISED("Revised"),
    UNREVISED("Unrevised");

    public static final String ERROR_MESSAGE_TEMPLATE = "%s not a valid Revision, expected one of: %s";
    public static final String DELIMITER = ", ";
    private String value;

    private Revision(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static Revision fromValue(String value) {
        return Arrays.stream(Revision.values()).filter(revision -> revision.getValue().equalsIgnoreCase(value)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format(ERROR_MESSAGE_TEMPLATE, value, Arrays.stream(Revision.values()).map(Enum::toString).collect(Collectors.joining(DELIMITER)))));
    }
}

