/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.net.URI;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import no.unit.nva.WithAssociatedArtifact;
import no.unit.nva.WithIdentifier;
import no.unit.nva.WithInternal;
import no.unit.nva.WithMetadata;
import no.unit.nva.commons.json.JsonUtils;
import no.unit.nva.identifiers.SortableIdentifier;
import no.unit.nva.model.AdditionalIdentifier;
import no.unit.nva.model.EntityDescription;
import no.unit.nva.model.FindableDoiRequirementsValidator;
import no.unit.nva.model.Organization;
import no.unit.nva.model.PublicationNote;
import no.unit.nva.model.PublicationStatus;
import no.unit.nva.model.Reference;
import no.unit.nva.model.ResearchProject;
import no.unit.nva.model.ResourceOwner;
import no.unit.nva.model.WithCopy;
import no.unit.nva.model.associatedartifacts.AssociatedArtifact;
import no.unit.nva.model.associatedartifacts.AssociatedArtifactList;
import no.unit.nva.model.exceptions.InvalidPublicationStatusTransitionException;
import no.unit.nva.model.funding.Funding;
import no.unit.nva.model.funding.FundingList;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.StringUtils;
import nva.commons.core.attempt.Try;
import nva.commons.core.ioutils.IoUtils;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class Publication
implements WithIdentifier,
WithInternal,
WithAssociatedArtifact,
WithMetadata,
WithCopy<Builder> {
    public static final Map<PublicationStatus, List<PublicationStatus>> validStatusTransitionsMap = Map.of(PublicationStatus.NEW, List.of(PublicationStatus.DRAFT), PublicationStatus.DRAFT, List.of(PublicationStatus.PUBLISHED, PublicationStatus.DRAFT_FOR_DELETION));
    private static final String MODEL_VERSION = "0.20.81";
    private static final String BASE_URI = "__BASE_URI__";
    private static final String PUBLICATION_CONTEXT = IoUtils.stringFromResources((Path)Path.of("publicationContext.json", new String[0]));
    private static final String ONTOLOGY = IoUtils.stringFromResources((Path)Path.of("publication-ontology.ttl", new String[0]));
    private SortableIdentifier identifier;
    private PublicationStatus status;
    private ResourceOwner resourceOwner;
    private Organization publisher;
    private Instant createdDate;
    private Instant modifiedDate;
    private Instant publishedDate;
    private Instant indexedDate;
    private URI handle;
    private URI doi;
    private URI link;
    private EntityDescription entityDescription;
    private List<ResearchProject> projects;
    private FundingList fundings;
    private Set<AdditionalIdentifier> additionalIdentifiers;
    private List<URI> subjects;
    private AssociatedArtifactList associatedArtifacts;
    private String rightsHolder;
    private URI duplicateOf;
    private List<PublicationNote> publicationNotes;

    public URI getDuplicateOf() {
        return this.duplicateOf;
    }

    public void setDuplicateOf(URI duplicateOf) {
        this.duplicateOf = duplicateOf;
    }

    public Set<AdditionalIdentifier> getAdditionalIdentifiers() {
        return Objects.nonNull(this.additionalIdentifiers) ? this.additionalIdentifiers : Collections.emptySet();
    }

    public void setAdditionalIdentifiers(Set<AdditionalIdentifier> additionalIdentifiers) {
        this.additionalIdentifiers = additionalIdentifiers;
    }

    @Override
    public Instant getCreatedDate() {
        return this.createdDate;
    }

    @Override
    public void setCreatedDate(Instant createdDate) {
        this.createdDate = createdDate;
    }

    @Override
    public PublicationStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(PublicationStatus status) {
        this.status = status;
    }

    @Override
    public URI getHandle() {
        return this.handle;
    }

    @Override
    public void setHandle(URI handle) {
        this.handle = handle;
    }

    @Override
    public Instant getPublishedDate() {
        return this.publishedDate;
    }

    @Override
    public void setPublishedDate(Instant publishedDate) {
        this.publishedDate = publishedDate;
    }

    @Override
    public Instant getModifiedDate() {
        return this.modifiedDate;
    }

    @Override
    public void setModifiedDate(Instant modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    @Override
    public ResourceOwner getResourceOwner() {
        return this.resourceOwner;
    }

    @Override
    public void setResourceOwner(ResourceOwner resourceOwner) {
        this.resourceOwner = resourceOwner;
    }

    @Override
    public Instant getIndexedDate() {
        return this.indexedDate;
    }

    @Override
    public void setIndexedDate(Instant indexedDate) {
        this.indexedDate = indexedDate;
    }

    @Override
    public URI getLink() {
        return this.link;
    }

    @Override
    public void setLink(URI link) {
        this.link = link;
    }

    @Override
    public Organization getPublisher() {
        return this.publisher;
    }

    @Override
    public void setPublisher(Organization publisher) {
        this.publisher = publisher;
    }

    @Override
    public URI getDoi() {
        return this.doi;
    }

    @Override
    public void setDoi(URI doi) {
        this.doi = doi;
    }

    @Override
    public SortableIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(SortableIdentifier identifier) {
        this.identifier = identifier;
    }

    @Override
    public EntityDescription getEntityDescription() {
        return this.entityDescription;
    }

    @Override
    public void setEntityDescription(EntityDescription entityDescription) {
        this.entityDescription = entityDescription;
    }

    @Override
    public List<ResearchProject> getProjects() {
        return Objects.nonNull(this.projects) ? this.projects : Collections.emptyList();
    }

    @Override
    public void setProjects(List<ResearchProject> projects) {
        this.projects = projects;
    }

    @Override
    public List<URI> getSubjects() {
        return Objects.nonNull(this.subjects) ? this.subjects : Collections.emptyList();
    }

    @Override
    public void setSubjects(List<URI> subjects) {
        this.subjects = subjects;
    }

    @Override
    public List<Funding> getFundings() {
        return Objects.nonNull(this.fundings) ? this.fundings : Collections.emptyList();
    }

    @Override
    public void setFundings(List<Funding> fundings) {
        this.fundings = new FundingList(fundings);
    }

    @Override
    public String getRightsHolder() {
        return this.rightsHolder;
    }

    @Override
    public void setRightsHolder(String rightsHolder) {
        this.rightsHolder = rightsHolder;
    }

    @JsonProperty(value="modelVersion")
    public String getModelVersion() {
        return MODEL_VERSION;
    }

    @JsonProperty(value="modelVersion")
    public void setModelVersion() {
    }

    @JsonGetter
    public List<PublicationNote> getPublicationNotes() {
        return Objects.nonNull(this.publicationNotes) ? this.publicationNotes : Collections.emptyList();
    }

    public void setPublicationNotes(List<PublicationNote> publicationNotes) {
        this.publicationNotes = publicationNotes;
    }

    @Override
    public AssociatedArtifactList getAssociatedArtifacts() {
        return Objects.nonNull(this.associatedArtifacts) ? this.associatedArtifacts : AssociatedArtifactList.empty();
    }

    @Override
    public void setAssociatedArtifacts(AssociatedArtifactList associatedArtifacts) {
        this.associatedArtifacts = associatedArtifacts;
    }

    @Override
    public Builder copy() {
        return new Builder().withIdentifier(this.getIdentifier()).withStatus(this.getStatus()).withResourceOwner(this.getResourceOwner()).withPublisher(this.getPublisher()).withCreatedDate(this.getCreatedDate()).withModifiedDate(this.getModifiedDate()).withPublishedDate(this.getPublishedDate()).withIndexedDate(this.getIndexedDate()).withHandle(this.getHandle()).withDoi(this.getDoi()).withLink(this.getLink()).withEntityDescription(this.getEntityDescription()).withProjects(this.getProjects()).withFundings(this.getFundings()).withAdditionalIdentifiers(this.getAdditionalIdentifiers()).withAssociatedArtifacts(this.getAssociatedArtifacts()).withSubjects(this.getSubjects()).withFundings(this.getFundings()).withRightsHolder(this.getRightsHolder()).withPublicationNotes(this.getPublicationNotes()).withDuplicateOf(this.getDuplicateOf());
    }

    public void updateStatus(PublicationStatus nextStatus) throws InvalidPublicationStatusTransitionException {
        this.verifyStatusTransition(nextStatus);
        this.setStatus(nextStatus);
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(new Object[]{this.getIdentifier(), this.getStatus(), this.getPublisher(), this.getCreatedDate(), this.getModifiedDate(), this.getPublishedDate(), this.getIndexedDate(), this.getHandle(), this.getDoi(), this.getLink(), this.getEntityDescription(), this.getProjects(), this.getFundings(), this.getAdditionalIdentifiers(), this.getSubjects(), this.getAssociatedArtifacts(), this.getRightsHolder(), this.getPublicationNotes(), this.getDuplicateOf()});
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Publication)) {
            return false;
        }
        Publication that = (Publication)o;
        boolean firstHalf = Objects.equals(this.getIdentifier(), that.getIdentifier()) && this.getStatus() == that.getStatus() && Objects.equals(this.getResourceOwner(), that.getResourceOwner()) && Objects.equals(this.getPublisher(), that.getPublisher()) && Objects.equals(this.getCreatedDate(), that.getCreatedDate()) && Objects.equals(this.getModifiedDate(), that.getModifiedDate()) && Objects.equals(this.getPublishedDate(), that.getPublishedDate());
        boolean secondHalf = Objects.equals(this.getIndexedDate(), that.getIndexedDate()) && Objects.equals(this.getHandle(), that.getHandle()) && Objects.equals(this.getDoi(), that.getDoi()) && Objects.equals(this.getLink(), that.getLink()) && Objects.equals(this.getEntityDescription(), that.getEntityDescription()) && Objects.equals(this.getAssociatedArtifacts(), that.getAssociatedArtifacts()) && Objects.equals(this.getProjects(), that.getProjects()) && Objects.equals(this.getFundings(), that.getFundings()) && Objects.equals(this.getAdditionalIdentifiers(), that.getAdditionalIdentifiers()) && Objects.equals(this.getSubjects(), that.getSubjects()) && Objects.equals(this.getRightsHolder(), that.getRightsHolder()) && Objects.equals(this.getPublicationNotes(), that.getPublicationNotes()) && Objects.equals(this.getDuplicateOf(), that.getDuplicateOf());
        return firstHalf && secondHalf;
    }

    public String toString() {
        return (String)Try.attempt(() -> JsonUtils.dtoObjectMapper.writeValueAsString((Object)this)).orElseThrow();
    }

    @JsonIgnore
    @Deprecated
    public String getJsonLdContext() {
        return IoUtils.stringFromResources((Path)Path.of("publicationContextDeprecated.json", new String[0]));
    }

    @JsonIgnore
    public static String getJsonLdContext(URI baseUri) {
        return PUBLICATION_CONTEXT.replace(BASE_URI, baseUri.toString());
    }

    @JsonIgnore
    public static String getOntology(URI baseUri) {
        return ONTOLOGY.replace(BASE_URI, baseUri.toString());
    }

    @JsonIgnore
    public boolean isPublishable() {
        return !PublicationStatus.DRAFT_FOR_DELETION.equals((Object)this.getStatus()) && this.hasMainTitle() && this.hasReferencedContent();
    }

    public boolean satisfiesFindableDoiRequirements() {
        return FindableDoiRequirementsValidator.meetsFindableDoiRequirements(this);
    }

    private void verifyStatusTransition(PublicationStatus nextStatus) throws InvalidPublicationStatusTransitionException {
        PublicationStatus currentStatus = this.getStatus();
        if (!validStatusTransitionsMap.get((Object)currentStatus).contains((Object)nextStatus)) {
            throw new InvalidPublicationStatusTransitionException(currentStatus, nextStatus);
        }
    }

    private boolean hasReferencedContent() {
        return this.getAssociatedArtifacts().isPublishable() || this.hasOriginalDoi();
    }

    private boolean hasMainTitle() {
        return Optional.ofNullable(this.getEntityDescription()).map(EntityDescription::getMainTitle).filter(string -> !StringUtils.isEmpty((String)string)).isPresent();
    }

    private boolean hasOriginalDoi() {
        return Optional.ofNullable(this.getEntityDescription()).map(EntityDescription::getReference).map(Reference::getDoi).isPresent();
    }

    public static final class Builder {
        private final Publication publication = new Publication();

        public Builder withIdentifier(SortableIdentifier identifier) {
            this.publication.setIdentifier(identifier);
            return this;
        }

        public Builder withStatus(PublicationStatus status) {
            this.publication.setStatus(status);
            return this;
        }

        public Builder withPublisher(Organization publisher) {
            this.publication.setPublisher(publisher);
            return this;
        }

        public Builder withCreatedDate(Instant createdDate) {
            this.publication.setCreatedDate(createdDate);
            return this;
        }

        public Builder withModifiedDate(Instant modifiedDate) {
            this.publication.setModifiedDate(modifiedDate);
            return this;
        }

        public Builder withPublishedDate(Instant publishedDate) {
            this.publication.setPublishedDate(publishedDate);
            return this;
        }

        public Builder withIndexedDate(Instant indexedDate) {
            this.publication.setIndexedDate(indexedDate);
            return this;
        }

        public Builder withHandle(URI handle) {
            this.publication.setHandle(handle);
            return this;
        }

        public Builder withDoi(URI doi) {
            this.publication.setDoi(doi);
            return this;
        }

        public Builder withLink(URI link) {
            this.publication.setLink(link);
            return this;
        }

        public Builder withEntityDescription(EntityDescription entityDescription) {
            this.publication.setEntityDescription(entityDescription);
            return this;
        }

        public Builder withAssociatedArtifacts(List<AssociatedArtifact> associatedArtifacts) {
            this.publication.setAssociatedArtifacts(new AssociatedArtifactList(associatedArtifacts));
            return this;
        }

        public Builder withProjects(List<ResearchProject> projects) {
            this.publication.setProjects(projects);
            return this;
        }

        public Builder withFundings(List<Funding> fundings) {
            this.publication.setFundings(fundings);
            return this;
        }

        public Builder withAdditionalIdentifiers(Set<AdditionalIdentifier> additionalIdentifiers) {
            this.publication.setAdditionalIdentifiers(additionalIdentifiers);
            return this;
        }

        public Builder withSubjects(List<URI> subjects) {
            this.publication.setSubjects(subjects);
            return this;
        }

        public Builder withResourceOwner(ResourceOwner randomResourceOwner) {
            this.publication.setResourceOwner(randomResourceOwner);
            return this;
        }

        public Publication build() {
            return this.publication;
        }

        public Builder withRightsHolder(String rightsHolder) {
            this.publication.setRightsHolder(rightsHolder);
            return this;
        }

        public Builder withPublicationNotes(List<PublicationNote> publicationNotes) {
            this.publication.setPublicationNotes(publicationNotes);
            return this;
        }

        public Builder withDuplicateOf(URI duplicateOf) {
            this.publication.setDuplicateOf(duplicateOf);
            return this;
        }
    }
}

