/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.instancetypes.artistic.music;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.stream.Collectors;

public enum MusicMediaType {
    COMPACT_DISC("CompactDisc"),
    DVD("DVD"),
    STREAMING("Streaming"),
    DIGITAL_FILE("DigitalFile"),
    VINYL("Vinyl"),
    OTHER("MusicMediaOther");

    public static final String ERROR_MESSAGE_TEMPLATE = "%s not a valid MusicMediaType, expected one of: %s";
    public static final String DELIMITER = ", ";
    private final String value;

    private MusicMediaType(String value) {
        this.value = value;
    }

    @Deprecated
    @JsonCreator
    public static MusicMediaType parse(String candidate) {
        return "Other".equalsIgnoreCase(candidate) ? OTHER : MusicMediaType.inlineableParseMethod(candidate);
    }

    public static MusicMediaType inlineableParseMethod(String candidate) {
        return Arrays.stream(MusicMediaType.values()).filter(value -> value.getValue().equalsIgnoreCase(candidate)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format(ERROR_MESSAGE_TEMPLATE, candidate, Arrays.stream(MusicMediaType.values()).map(Enum::toString).collect(Collectors.joining(DELIMITER)))));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }
}

