/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.associatedartifacts.file;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import no.unit.nva.model.Revision;

public enum PublisherVersion {
    PUBLISHED_VERSION("PublishedVersion"),
    ACCEPTED_VERSION("AcceptedVersion");

    public static final String ERROR_MESSAGE_TEMPLATE = "%s not a valid PublisherVersion, expected one of: %s";
    public static final String ERROR_MESSAGE_CANNOT_PARSE_THIS_OBJECT = "%s not a valid object, expected either String or boolean";
    public static final String DELIMITER = ", ";
    private final String value;

    private PublisherVersion(String value) {
        this.value = value;
    }

    public static PublisherVersion parse(Object candidate) {
        if (candidate instanceof Boolean) {
            Boolean publisherAuthority = (Boolean)candidate;
            return PublisherVersion.parseFromBoolean(publisherAuthority);
        }
        if (candidate instanceof String) {
            String stringCandidate = (String)candidate;
            return PublisherVersion.parseFromString(stringCandidate);
        }
        if (Objects.isNull(candidate)) {
            return null;
        }
        if (candidate instanceof PublisherVersion) {
            PublisherVersion publisherVersion = (PublisherVersion)((Object)candidate);
            return publisherVersion;
        }
        throw new UnsupportedOperationException(String.format(ERROR_MESSAGE_CANNOT_PARSE_THIS_OBJECT, candidate.getClass().getSimpleName()));
    }

    public static PublisherVersion parseFromBoolean(boolean candidate) {
        return candidate ? PUBLISHED_VERSION : ACCEPTED_VERSION;
    }

    public static PublisherVersion parseFromString(String candidate) {
        return Arrays.stream(PublisherVersion.values()).filter(revision -> revision.getValue().equalsIgnoreCase(candidate)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format(ERROR_MESSAGE_TEMPLATE, candidate, Arrays.stream(Revision.values()).map(Enum::toString).collect(Collectors.joining(DELIMITER)))));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }
}

