/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.associatedartifacts.file;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.net.URI;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import no.unit.nva.commons.json.JsonSerializable;
import no.unit.nva.model.associatedartifacts.AssociatedArtifact;
import no.unit.nva.model.associatedartifacts.NullRightsRetentionStrategy;
import no.unit.nva.model.associatedartifacts.RightsRetentionStrategy;
import no.unit.nva.model.associatedartifacts.RightsRetentionStrategyConfiguration;
import no.unit.nva.model.associatedartifacts.file.AdministrativeAgreement;
import no.unit.nva.model.associatedartifacts.file.MissingLicenseException;
import no.unit.nva.model.associatedartifacts.file.PublishedFile;
import no.unit.nva.model.associatedartifacts.file.PublisherVersion;
import no.unit.nva.model.associatedartifacts.file.UnpublishedFile;
import no.unit.nva.model.associatedartifacts.file.UploadDetails;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="PublishedFile", value=PublishedFile.class), @JsonSubTypes.Type(names={"UnpublishedFile", "File"}, value=UnpublishedFile.class), @JsonSubTypes.Type(name="UnpublishableFile", value=AdministrativeAgreement.class)})
public abstract class File
implements JsonSerializable,
AssociatedArtifact {
    public static final String IDENTIFIER_FIELD = "identifier";
    public static final String NAME_FIELD = "name";
    public static final String MIME_TYPE_FIELD = "mimeType";
    public static final String SIZE_FIELD = "size";
    public static final String LICENSE_FIELD = "license";
    public static final String ADMINISTRATIVE_AGREEMENT_FIELD = "administrativeAgreement";
    public static final String PUBLISHER_AUTHORITY_FIELD = "publisherAuthority";
    public static final String PUBLISHER_VERSION_FIELD = "publisherVersion";
    public static final String EMBARGO_DATE_FIELD = "embargoDate";
    public static final String RIGTHTS_RETENTION_STRATEGY = "rightsRetentionStrategy";
    public static final String UPLOAD_DETAILS = "uploadDetails";
    public static final Map<String, URI> LICENSE_MAP = Map.of("CC BY", URI.create("https://creativecommons.org/licenses/by/4.0"), "CC BY-NC", URI.create("https://creativecommons.org/licenses/by-nc/4.0"), "CC BY-NC-ND", URI.create("https://creativecommons.org/licenses/by-nc-nd/4.0"), "CC BY-NC-SA", URI.create("https://creativecommons.org/licenses/by-nc-sa/4.0"), "CC BY-ND", URI.create("https://creativecommons.org/licenses/by-nd/4.0"), "CC BY-SA", URI.create("https://creativecommons.org/licenses/by-sa/4.0"), "CC0", URI.create("https://creativecommons.org/publicdomain/zero/1.0"), "RightsReserved", URI.create("http://rightsstatements.org/vocab/InC/1.0/"));
    public static final String MISSING_LICENSE = "The file is not annotated as an administrative agreement and should have a license";
    public static final String CCBY_LICENSE = "Files with the CustomerRightsRetentionStrategy must have the CC BY license if publisherAuthority is false.";
    public static final String ERROR_MESSAGE = "The specified license cannot be converted into a valid URI license: ";
    public static final String LEGAL_NOTE_FIELD = "legalNote";
    private static final Supplier<Pattern> LICENSE_VALIDATION_PATTERN = () -> Pattern.compile("^(http|https)://.*$");
    @JsonProperty(value="identifier")
    private final UUID identifier;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="mimeType")
    private final String mimeType;
    @JsonProperty(value="size")
    private final Long size;
    @JsonProperty(value="license")
    private final URI license;
    @JsonProperty(value="administrativeAgreement")
    private final boolean administrativeAgreement;
    @JsonProperty(value="publisherVersion")
    private final PublisherVersion publisherVersion;
    @JsonProperty(value="embargoDate")
    private final Instant embargoDate;
    @JsonProperty(value="rightsRetentionStrategy")
    private RightsRetentionStrategy rightsRetentionStrategy;
    @JsonProperty(value="legalNote")
    private final String legalNote;
    @JsonProperty(value="uploadDetails")
    private final UploadDetails uploadDetails;

    protected File(@JsonProperty(value="identifier") UUID identifier, @JsonProperty(value="name") String name, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="size") Long size, @JsonProperty(value="license") Object license, @JsonProperty(value="administrativeAgreement") boolean administrativeAgreement, @JsonProperty(value="publisherVersion") @JsonAlias(value={"publisherAuthority"}) Object publisherAuthority, @JsonProperty(value="embargoDate") Instant embargoDate, @JsonProperty(value="rightsRetentionStrategy") RightsRetentionStrategy rightsRetentionStrategy, @JsonProperty(value="legalNote") String legalNote, @JsonProperty(value="uploadDetails") UploadDetails uploadDetails) {
        this.identifier = identifier;
        this.name = name;
        this.mimeType = mimeType;
        this.size = size;
        this.license = this.validateUriLicense(this.parseLicense(license));
        this.administrativeAgreement = administrativeAgreement;
        this.publisherVersion = PublisherVersion.parse(publisherAuthority);
        this.embargoDate = embargoDate;
        this.rightsRetentionStrategy = this.assignDefaultStrategyIfNull(rightsRetentionStrategy);
        this.legalNote = legalNote;
        this.uploadDetails = uploadDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void validate() {
        if (!this.administrativeAgreement && Objects.isNull(this.license)) {
            throw new MissingLicenseException(MISSING_LICENSE);
        }
    }

    public UploadDetails getUploadDetails() {
        return this.uploadDetails;
    }

    public UUID getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Long getSize() {
        return this.size;
    }

    public String getLegalNote() {
        return this.legalNote;
    }

    public URI getLicense() {
        return this.license;
    }

    public boolean isAdministrativeAgreement() {
        return this.administrativeAgreement;
    }

    @JsonIgnore
    @Deprecated
    public boolean isPublisherAuthority() {
        return this.publisherVersion == PublisherVersion.PUBLISHED_VERSION;
    }

    public PublisherVersion getPublisherVersion() {
        return this.publisherVersion;
    }

    public Optional<Instant> getEmbargoDate() {
        return Optional.ofNullable(this.embargoDate);
    }

    public RightsRetentionStrategy getRightsRetentionStrategy() {
        return this.rightsRetentionStrategy;
    }

    public void setRightsRetentionStrategy(RightsRetentionStrategy rightsRetentionStrategy) {
        this.rightsRetentionStrategy = rightsRetentionStrategy;
    }

    public boolean fileDoesNotHaveActiveEmbargo() {
        return this.getEmbargoDate().map(date -> Instant.now().isAfter((Instant)date)).orElse(true);
    }

    public UnpublishedFile toUnpublishedFile() {
        return new UnpublishedFile(this.getIdentifier(), this.getName(), this.getMimeType(), this.getSize(), this.getLicense(), this.isAdministrativeAgreement(), (Object)this.getPublisherVersion(), this.getEmbargoDate().orElse(null), this.getRightsRetentionStrategy(), this.getLegalNote(), this.getUploadDetails());
    }

    public PublishedFile toPublishedFile() {
        return new PublishedFile(this.getIdentifier(), this.getName(), this.getMimeType(), this.getSize(), this.getLicense(), this.isAdministrativeAgreement(), (Object)this.getPublisherVersion(), this.getEmbargoDate().orElse(null), this.getRightsRetentionStrategy(), this.getLegalNote(), Instant.now(), this.getUploadDetails());
    }

    public final AdministrativeAgreement toAdministrativeAgreement() {
        if (this.isAdministrativeAgreement()) {
            return new AdministrativeAgreement(this.getIdentifier(), this.getName(), this.getMimeType(), this.getSize(), this.getLicense(), this.isAdministrativeAgreement(), (Object)this.getPublisherVersion(), this.getEmbargoDate().orElse(null), this.getUploadDetails());
        }
        throw new IllegalStateException("Can not make unpublishable a non-administrative agreement");
    }

    public final AdministrativeAgreement toUnpublishableFile() {
        return new AdministrativeAgreement(this.getIdentifier(), this.getName(), this.getMimeType(), this.getSize(), this.getLicense(), this.isAdministrativeAgreement(), (Object)this.getPublisherVersion(), this.getEmbargoDate().orElse(null), this.getUploadDetails());
    }

    public abstract boolean isVisibleForNonOwner();

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(new Object[]{this.getIdentifier(), this.getName(), this.getMimeType(), this.getSize(), this.getLicense(), this.isAdministrativeAgreement(), this.getUploadDetails(), this.getPublisherVersion(), this.getEmbargoDate(), this.getRightsRetentionStrategy()});
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof File)) {
            return false;
        }
        File file = (File)o;
        return this.isAdministrativeAgreement() == file.isAdministrativeAgreement() && this.getPublisherVersion() == file.getPublisherVersion() && Objects.equals(this.getIdentifier(), file.getIdentifier()) && Objects.equals(this.getName(), file.getName()) && Objects.equals(this.getMimeType(), file.getMimeType()) && Objects.equals(this.getSize(), file.getSize()) && Objects.equals(this.getLicense(), file.getLicense()) && Objects.equals(this.getEmbargoDate(), file.getEmbargoDate()) && Objects.equals(this.getUploadDetails(), file.getUploadDetails()) && Objects.equals(this.getRightsRetentionStrategy(), file.getRightsRetentionStrategy());
    }

    public String toString() {
        return this.toJsonString();
    }

    private RightsRetentionStrategy assignDefaultStrategyIfNull(RightsRetentionStrategy strategy) {
        return Objects.nonNull(strategy) ? strategy : NullRightsRetentionStrategy.create(RightsRetentionStrategyConfiguration.UNKNOWN);
    }

    private URI parseLicense(Object license) {
        if (Objects.isNull(license)) {
            return null;
        }
        if (license instanceof LinkedHashMap) {
            String licenseName = this.getLicenseValue((LinkedHashMap)license);
            return LICENSE_MAP.get(licenseName);
        }
        return URI.create(license.toString());
    }

    private String getLicenseValue(Map<?, ?> license) {
        return (String)license.get(IDENTIFIER_FIELD);
    }

    private URI validateUriLicense(URI license) {
        if (Objects.isNull(license) || !this.isValidUriLicense(license) || license.equals(LICENSE_MAP.get("RightsReserved"))) {
            return license;
        }
        return this.formatValidUriLicense(license);
    }

    private boolean isValidUriLicense(URI license) {
        Matcher matcher = LICENSE_VALIDATION_PATTERN.get().matcher(license.toString());
        return matcher.matches();
    }

    private URI formatValidUriLicense(URI license) {
        String formatedLicenseURL = license.toString().replaceFirst(license.getScheme(), "https").replaceAll("/$", "").toLowerCase(Locale.ROOT);
        return URI.create(formatedLicenseURL);
    }

    public static final class Builder {
        private UUID identifier;
        private String name;
        private String mimeType;
        private Long size;
        private URI license;
        private boolean administrativeAgreement;
        private PublisherVersion publisherVersion;
        private Instant embargoDate;
        private RightsRetentionStrategy rightsRetentionStrategy;
        private String legalNote;
        private UploadDetails uploadDetails;

        private Builder() {
        }

        public Builder withIdentifier(UUID identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withMimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder withSize(Long size) {
            this.size = size;
            return this;
        }

        public Builder withLicense(URI license) {
            this.license = license;
            return this;
        }

        public Builder withAdministrativeAgreement(boolean administrativeAgreement) {
            this.administrativeAgreement = administrativeAgreement;
            return this;
        }

        public Builder withUploadDetails(UploadDetails uploadDetails) {
            this.uploadDetails = uploadDetails;
            return this;
        }

        @Deprecated
        public Builder withPublisherAuthority(boolean publisherAuthority) {
            this.publisherVersion = PublisherVersion.parse(publisherAuthority);
            return this;
        }

        public Builder withPublisherVersion(PublisherVersion publisherVersion) {
            this.publisherVersion = publisherVersion;
            return this;
        }

        public Builder withEmbargoDate(Instant embargoDate) {
            this.embargoDate = embargoDate;
            return this;
        }

        public Builder withRightsRetentionStrategy(RightsRetentionStrategy rightsRetentionStrategy) {
            this.rightsRetentionStrategy = rightsRetentionStrategy;
            return this;
        }

        public Builder withLegalNote(String legalNote) {
            this.legalNote = legalNote;
            return this;
        }

        public File buildPublishedFile() {
            return new PublishedFile(this.identifier, this.name, this.mimeType, this.size, this.license, this.administrativeAgreement, (Object)this.publisherVersion, this.embargoDate, this.rightsRetentionStrategy, this.legalNote, Instant.now(), this.uploadDetails);
        }

        public File buildUnpublishedFile() {
            return new UnpublishedFile(this.identifier, this.name, this.mimeType, this.size, this.license, this.administrativeAgreement, (Object)this.publisherVersion, this.embargoDate, this.rightsRetentionStrategy, this.legalNote, this.uploadDetails);
        }

        public File buildUnpublishableFile() {
            return new AdministrativeAgreement(this.identifier, this.name, this.mimeType, this.size, this.license, this.administrativeAgreement, (Object)this.publisherVersion, this.embargoDate, this.uploadDetails);
        }
    }
}

