/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.contexttypes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import no.unit.nva.model.contexttypes.BookSeries;
import no.unit.nva.model.contexttypes.utils.IssnUtil;
import no.unit.nva.model.exceptions.InvalidIssnException;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.StringUtils;
import nva.commons.core.attempt.Try;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class UnconfirmedSeries
implements BookSeries {
    public static final String TITLE = "title";
    public static final String ISSN = "issn";
    public static final String ONLINE_ISSN = "onlineIssn";
    @JsonProperty(value="title")
    private final String title;
    @JsonProperty(value="issn")
    private final String issn;
    @JsonProperty(value="onlineIssn")
    private final String onlineIssn;

    @JsonCreator
    public UnconfirmedSeries(@JsonProperty(value="title") String title, @JsonProperty(value="issn") String issn, @JsonProperty(value="onlineIssn") String onlineIssn) throws InvalidIssnException {
        this.title = title;
        this.issn = this.validateIssn(issn);
        this.onlineIssn = this.validateIssn(onlineIssn);
    }

    public static UnconfirmedSeries fromTitle(String title) {
        return (UnconfirmedSeries)Try.attempt(() -> new UnconfirmedSeries(title, null, null)).orElseThrow();
    }

    @JacocoGenerated
    public String getOnlineIssn() {
        return this.onlineIssn;
    }

    @JacocoGenerated
    public String getIssn() {
        return this.issn;
    }

    @JacocoGenerated
    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean isConfirmed() {
        return false;
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getTitle(), this.getIssn(), this.getOnlineIssn());
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnconfirmedSeries)) {
            return false;
        }
        UnconfirmedSeries that = (UnconfirmedSeries)o;
        return Objects.equals(this.getTitle(), that.getTitle()) && Objects.equals(this.getIssn(), that.getIssn()) && Objects.equals(this.getOnlineIssn(), that.getOnlineIssn());
    }

    private String validateIssn(String issn) throws InvalidIssnException {
        return StringUtils.isBlank((String)issn) ? null : IssnUtil.checkIssn(issn);
    }
}

