/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.tools.generator;

import cn.binarywang.tools.generator.base.GenericGenerator;
import java.util.Date;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;

public class BankCardNumberGenerator
extends GenericGenerator {
    private static GenericGenerator instance = new BankCardNumberGenerator();

    private BankCardNumberGenerator() {
    }

    public static GenericGenerator getInstance() {
        return instance;
    }

    @Override
    public String generate() {
        Random random = this.getRandomInstance();
        Integer prev = 622126 + random.nextInt(800);
        return BankCardNumberGenerator.generateByPrefix(prev);
    }

    public static String generateByPrefix(Integer prefix) {
        Random random = new Random(new Date().getTime());
        String bardNo = prefix + StringUtils.leftPad((String)(random.nextInt(999999999) + ""), (int)9, (String)"0");
        char[] chs = bardNo.trim().toCharArray();
        int luhmSum = 0;
        int i = chs.length - 1;
        int j = 0;
        while (i >= 0) {
            int k = chs[i] - 48;
            if (j % 2 == 0) {
                k *= 2;
                k = k / 10 + k % 10;
            }
            luhmSum += k;
            --i;
            ++j;
        }
        char checkCode = luhmSum % 10 == 0 ? (char)'0' : (char)(10 - luhmSum % 10 + 48);
        return bardNo + checkCode;
    }
}

