/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.api.impl;

import java.util.Map;
import me.chanjar.weixin.channel.api.BaseWxChannelMessageService;
import me.chanjar.weixin.channel.api.WxChannelService;
import me.chanjar.weixin.channel.bean.message.after.AfterSaleMessage;
import me.chanjar.weixin.channel.bean.message.after.ComplaintMessage;
import me.chanjar.weixin.channel.bean.message.coupon.CouponActionMessage;
import me.chanjar.weixin.channel.bean.message.coupon.CouponReceiveMessage;
import me.chanjar.weixin.channel.bean.message.coupon.UserCouponExpireMessage;
import me.chanjar.weixin.channel.bean.message.fund.AccountNotifyMessage;
import me.chanjar.weixin.channel.bean.message.fund.QrNotifyMessage;
import me.chanjar.weixin.channel.bean.message.fund.WithdrawNotifyMessage;
import me.chanjar.weixin.channel.bean.message.order.OrderCancelMessage;
import me.chanjar.weixin.channel.bean.message.order.OrderConfirmMessage;
import me.chanjar.weixin.channel.bean.message.order.OrderDeliveryMessage;
import me.chanjar.weixin.channel.bean.message.order.OrderExtMessage;
import me.chanjar.weixin.channel.bean.message.order.OrderIdMessage;
import me.chanjar.weixin.channel.bean.message.order.OrderPayMessage;
import me.chanjar.weixin.channel.bean.message.order.OrderSettleMessage;
import me.chanjar.weixin.channel.bean.message.order.OrderStatusMessage;
import me.chanjar.weixin.channel.bean.message.product.BrandMessage;
import me.chanjar.weixin.channel.bean.message.product.CategoryAuditMessage;
import me.chanjar.weixin.channel.bean.message.product.SpuAuditMessage;
import me.chanjar.weixin.channel.bean.message.supplier.SupplierItemMessage;
import me.chanjar.weixin.channel.message.WxChannelMessage;
import me.chanjar.weixin.channel.message.WxChannelMessageRouter;
import me.chanjar.weixin.channel.message.WxChannelMessageRouterRule;
import me.chanjar.weixin.channel.message.rule.HandlerConsumer;
import me.chanjar.weixin.channel.util.JsonUtils;
import me.chanjar.weixin.common.session.WxSessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseWxChannelMessageServiceImpl
implements BaseWxChannelMessageService {
    private static final Logger log = LoggerFactory.getLogger(BaseWxChannelMessageServiceImpl.class);
    protected WxChannelMessageRouter router;

    public BaseWxChannelMessageServiceImpl(WxChannelMessageRouter router) {
        this.router = router;
        this.addDefaultRule();
    }

    protected void addDefaultRule() {
        this.addRule(BrandMessage.class, "channels_ec_brand", this::brandUpdate);
        this.addRule(SpuAuditMessage.class, "product_spu_audit", this::spuAudit);
        this.addRule(SpuAuditMessage.class, "product_spu_listing", this::spuStatusUpdate);
        this.addRule(SpuAuditMessage.class, "product_spu_update", this::spuUpdate);
        this.addRule(CategoryAuditMessage.class, "product_category_audit", this::categoryAudit);
        this.addRule(OrderIdMessage.class, "channels_ec_order_new", this::orderNew);
        this.addRule(OrderCancelMessage.class, "channels_ec_order_cancel", this::orderCancel);
        this.addRule(OrderPayMessage.class, "channels_ec_order_pay", this::orderPay);
        this.addRule(OrderDeliveryMessage.class, "channels_ec_order_deliver", this::orderDelivery);
        this.addRule(OrderConfirmMessage.class, "channels_ec_order_confirm", this::orderConfirm);
        this.addRule(OrderSettleMessage.class, "channels_ec_order_settle", this::orderSettle);
        this.addRule(OrderExtMessage.class, "channels_ec_order_ext_info_update", this::orderExtInfoUpdate);
        this.addRule(OrderStatusMessage.class, "product_order_status_update", this::orderStatusUpdate);
        this.addRule(AfterSaleMessage.class, "channels_ec_aftersale_update", this::afterSaleStatusUpdate);
        this.addRule(ComplaintMessage.class, "channels_ec_complaint_update", this::complaintNotify);
        this.addRule(CouponReceiveMessage.class, "channels_ec_coupon_receive", this::couponReceive);
        this.addRule(CouponActionMessage.class, "channels_ec_coupon_create", this::couponCreate);
        this.addRule(CouponActionMessage.class, "channels_ec_coupon_delete", this::couponDelete);
        this.addRule(CouponActionMessage.class, "channels_ec_coupon_expire", this::couponExpire);
        this.addRule(CouponActionMessage.class, "channels_ec_coupon_info_change", this::couponUpdate);
        this.addRule(CouponActionMessage.class, "channels_ec_coupon_invalid", this::couponInvalid);
        this.addRule(UserCouponExpireMessage.class, "channels_ec_user_coupon_expire", this::userCouponExpire);
        this.addRule(UserCouponExpireMessage.class, "channels_ec_user_coupon_unuse", this::userCouponUnuse);
        this.addRule(UserCouponExpireMessage.class, "channels_ec_user_coupon_use", this::userCouponUse);
        this.addRule(AccountNotifyMessage.class, "channels_ec_acct_notify", this::accountNotify);
        this.addRule(WithdrawNotifyMessage.class, "channels_ec_withdraw_notify", this::withdrawNotify);
        this.addRule(QrNotifyMessage.class, "qrcode_status", this::qrNotify);
        this.addRule(SupplierItemMessage.class, "head_supplier_item_update", this::supplierItemUpdate);
    }

    protected <T extends WxChannelMessage> void addRule(Class<T> clazz, String event, HandlerConsumer<T, String, String, Map<String, Object>, WxSessionManager> consumer) {
        WxChannelMessageRouterRule<T> rule = new WxChannelMessageRouterRule<T>();
        rule.setMessageClass(clazz).setEvent(event).setAsync(true);
        rule.getHandlers().add((message, content, appId, context, sessionManager) -> {
            consumer.accept(message, content, appId, context, sessionManager);
            return "success";
        });
        this.addRule(rule);
    }

    @Override
    public void addRule(WxChannelMessageRouterRule<? extends WxChannelMessage> rule) {
        this.router.getRules().add(rule);
    }

    @Override
    public Object route(WxChannelMessage message, String content, String appId, WxChannelService service) {
        return this.router.route(message, content, appId, service);
    }

    @Override
    public void orderNew(OrderIdMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u8ba2\u5355\u4e0b\u5355:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void orderCancel(OrderCancelMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u8ba2\u5355\u53d6\u6d88:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void orderPay(OrderPayMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u8ba2\u5355\u652f\u4ed8\u6210\u529f:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void orderDelivery(OrderDeliveryMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u8ba2\u5355\u53d1\u8d27:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void orderConfirm(OrderConfirmMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u8ba2\u5355\u786e\u8ba4\u6536\u8d27:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void orderSettle(OrderSettleMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u8ba2\u5355\u7ed3\u7b97:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void orderExtInfoUpdate(OrderExtMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u8ba2\u5355\u5176\u4ed6\u4fe1\u606f\u66f4\u65b0:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void orderStatusUpdate(OrderStatusMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u8ba2\u5355\u72b6\u6001\u66f4\u65b0:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void spuAudit(SpuAuditMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u5546\u54c1\u5ba1\u6838:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void spuStatusUpdate(SpuAuditMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u5546\u54c1\u72b6\u6001\u66f4\u65b0:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void spuUpdate(SpuAuditMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u5546\u54c1\u66f4\u65b0:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void categoryAudit(CategoryAuditMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u5206\u7c7b\u5ba1\u6838:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void brandUpdate(BrandMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u54c1\u724c\u66f4\u65b0:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void afterSaleStatusUpdate(AfterSaleMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u552e\u540e\u72b6\u6001\u66f4\u65b0:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void complaintNotify(ComplaintMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u6295\u8bc9\u901a\u77e5:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void couponReceive(CouponReceiveMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u4f18\u60e0\u5238\u9886\u53d6:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void couponCreate(CouponActionMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u4f18\u60e0\u5238\u521b\u5efa:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void couponDelete(CouponActionMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u4f18\u60e0\u5238\u5220\u9664:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void couponExpire(CouponActionMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u4f18\u60e0\u5238\u8fc7\u671f:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void couponUpdate(CouponActionMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u4f18\u60e0\u5238\u66f4\u65b0:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void couponInvalid(CouponActionMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u4f18\u60e0\u5238\u5931\u6548:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void userCouponExpire(UserCouponExpireMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u7528\u6237\u4f18\u60e0\u5238\u8fc7\u671f:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void userCouponUse(UserCouponExpireMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u7528\u6237\u4f18\u60e0\u5238\u4f7f\u7528:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void userCouponUnuse(UserCouponExpireMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u7528\u6237\u4f18\u60e0\u5238\u53d6\u6d88\u4f7f\u7528:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void accountNotify(AccountNotifyMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u8d26\u6237\u901a\u77e5:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void withdrawNotify(WithdrawNotifyMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u63d0\u73b0\u901a\u77e5:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void qrNotify(QrNotifyMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u4e8c\u7ef4\u7801\u901a\u77e5:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public void supplierItemUpdate(SupplierItemMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u4f9b\u5e94\u5546\u5546\u54c1\u66f4\u65b0:{}", (Object)JsonUtils.encode(message));
    }

    @Override
    public Object defaultMessageHandler(WxChannelMessage message, String content, String appId, Map<String, Object> context, WxSessionManager sessionManager) {
        log.info("\u9ed8\u8ba4\u6d88\u606f\u5904\u7406:{}", (Object)JsonUtils.encode(message));
        return null;
    }
}

