/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.api.impl;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import me.chanjar.weixin.channel.api.WxChannelAddressService;
import me.chanjar.weixin.channel.api.WxChannelAfterSaleService;
import me.chanjar.weixin.channel.api.WxChannelBasicService;
import me.chanjar.weixin.channel.api.WxChannelBrandService;
import me.chanjar.weixin.channel.api.WxChannelCategoryService;
import me.chanjar.weixin.channel.api.WxChannelCouponService;
import me.chanjar.weixin.channel.api.WxChannelFreightTemplateService;
import me.chanjar.weixin.channel.api.WxChannelFundService;
import me.chanjar.weixin.channel.api.WxChannelOrderService;
import me.chanjar.weixin.channel.api.WxChannelProductService;
import me.chanjar.weixin.channel.api.WxChannelService;
import me.chanjar.weixin.channel.api.WxChannelSharerService;
import me.chanjar.weixin.channel.api.WxChannelWarehouseService;
import me.chanjar.weixin.channel.api.WxLeagueProductService;
import me.chanjar.weixin.channel.api.WxLeaguePromoterService;
import me.chanjar.weixin.channel.api.WxLeagueSupplierService;
import me.chanjar.weixin.channel.api.WxLeagueWindowService;
import me.chanjar.weixin.channel.api.impl.WxChannelAddressServiceImpl;
import me.chanjar.weixin.channel.api.impl.WxChannelAfterSaleServiceImpl;
import me.chanjar.weixin.channel.api.impl.WxChannelBasicServiceImpl;
import me.chanjar.weixin.channel.api.impl.WxChannelBrandServiceImpl;
import me.chanjar.weixin.channel.api.impl.WxChannelCategoryServiceImpl;
import me.chanjar.weixin.channel.api.impl.WxChannelCouponServiceImpl;
import me.chanjar.weixin.channel.api.impl.WxChannelFreightTemplateServiceImpl;
import me.chanjar.weixin.channel.api.impl.WxChannelFundServiceImpl;
import me.chanjar.weixin.channel.api.impl.WxChannelOrderServiceImpl;
import me.chanjar.weixin.channel.api.impl.WxChannelProductServiceImpl;
import me.chanjar.weixin.channel.api.impl.WxChannelSharerServiceImpl;
import me.chanjar.weixin.channel.api.impl.WxChannelWarehouseServiceImpl;
import me.chanjar.weixin.channel.api.impl.WxLeagueProductServiceImpl;
import me.chanjar.weixin.channel.api.impl.WxLeaguePromoterServiceImpl;
import me.chanjar.weixin.channel.api.impl.WxLeagueSupplierServiceImpl;
import me.chanjar.weixin.channel.api.impl.WxLeagueWindowServiceImpl;
import me.chanjar.weixin.channel.config.WxChannelConfig;
import me.chanjar.weixin.channel.util.JsonUtils;
import me.chanjar.weixin.common.api.WxConsts;
import me.chanjar.weixin.common.bean.ToJson;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.common.util.DataUtils;
import me.chanjar.weixin.common.util.crypto.SHA1;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseWxChannelServiceImpl<H, P>
implements WxChannelService,
RequestHttp<H, P> {
    private static final Logger log = LoggerFactory.getLogger(BaseWxChannelServiceImpl.class);
    private final WxChannelBasicService basicService = new WxChannelBasicServiceImpl(this);
    private final WxChannelCategoryService categoryService = new WxChannelCategoryServiceImpl(this);
    private final WxChannelBrandService brandService = new WxChannelBrandServiceImpl(this);
    private final WxChannelProductService productService = new WxChannelProductServiceImpl(this);
    private final WxChannelWarehouseService warehouseService = new WxChannelWarehouseServiceImpl(this);
    private final WxChannelOrderService orderService = new WxChannelOrderServiceImpl(this);
    private final WxChannelAfterSaleService afterSaleService = new WxChannelAfterSaleServiceImpl(this);
    private final WxChannelFreightTemplateService freightTemplateService = new WxChannelFreightTemplateServiceImpl(this);
    private final WxChannelAddressService addressService = new WxChannelAddressServiceImpl(this);
    private final WxChannelCouponService couponService = new WxChannelCouponServiceImpl(this);
    private final WxChannelSharerService sharerService = new WxChannelSharerServiceImpl(this);
    private final WxChannelFundService fundService = new WxChannelFundServiceImpl(this);
    private WxLeagueWindowService leagueWindowService = null;
    private WxLeagueSupplierService leagueSupplierService = null;
    private WxLeaguePromoterService leaguePromoterService = null;
    private WxLeagueProductService leagueProductService = null;
    protected WxChannelConfig config;
    private int retrySleepMillis = 1000;
    private int maxRetryTimes = 5;

    @Override
    public RequestHttp getRequestHttp() {
        return this;
    }

    @Override
    public boolean checkSignature(String timestamp, String nonce, String signature) {
        try {
            return SHA1.gen((String[])new String[]{this.getConfig().getToken(), timestamp, nonce}).equals(signature);
        }
        catch (Exception e) {
            log.error("Checking signature failed, and the reason is :" + e.getMessage());
            return false;
        }
    }

    @Override
    public String getAccessToken() throws WxErrorException {
        return this.getAccessToken(false);
    }

    @Override
    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        if (!forceRefresh && !this.getConfig().isAccessTokenExpired()) {
            return this.getConfig().getAccessToken();
        }
        Lock lock = this.getConfig().getAccessTokenLock();
        boolean locked = false;
        try {
            do {
                locked = lock.tryLock(100L, TimeUnit.MILLISECONDS);
                if (forceRefresh || this.getConfig().isAccessTokenExpired()) continue;
                String string = this.getConfig().getAccessToken();
                return string;
            } while (!locked);
            String response = this.doGetAccessTokenRequest();
            String string = this.extractAccessToken(response);
            return string;
        }
        catch (IOException | InterruptedException e) {
            throw new WxRuntimeException((Throwable)e);
        }
        finally {
            if (locked) {
                lock.unlock();
            }
        }
    }

    protected abstract String doGetAccessTokenRequest() throws IOException;

    public String get(String url, String queryParam) throws WxErrorException {
        return (String)this.execute(SimpleGetRequestExecutor.create((RequestHttp)this), url, queryParam);
    }

    public String post(String url, String postData) throws WxErrorException {
        return (String)this.execute(SimplePostRequestExecutor.create((RequestHttp)this), url, postData);
    }

    public String post(String url, Object obj) throws WxErrorException {
        return (String)this.execute(SimplePostRequestExecutor.create((RequestHttp)this), url, JsonUtils.encode(obj));
    }

    public String post(String url, ToJson obj) throws WxErrorException {
        return this.post(url, obj.toJson());
    }

    public String post(String url, JsonObject jsonObject) throws WxErrorException {
        return this.post(url, jsonObject.toString());
    }

    @Override
    public <T, E> T execute(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        return this.execute0(executor, uri, data, true);
    }

    @Override
    public <T, E> T executeWithoutLog(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        return this.execute0(executor, uri, data, false);
    }

    protected <T, E> T execute0(RequestExecutor<T, E> executor, String uri, E data, boolean printResult) throws WxErrorException {
        int retryTimes = 0;
        while (true) {
            try {
                return this.executeInternal(executor, uri, data, false, printResult);
            }
            catch (WxErrorException e) {
                if (retryTimes + 1 > this.maxRetryTimes) {
                    log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                    throw new WxErrorException(WxError.builder().errorCode(e.getError().getErrorCode()).errorMsg("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570\uff01").build());
                }
                WxError error = e.getError();
                if (error.getErrorCode() == -1) {
                    int sleepMillis = this.retrySleepMillis * (1 << retryTimes);
                    try {
                        log.warn("\u5fae\u4fe1\u7cfb\u7edf\u7e41\u5fd9\uff0c{} ms \u540e\u91cd\u8bd5(\u7b2c{}\u6b21)", (Object)sleepMillis, (Object)(retryTimes + 1));
                        Thread.sleep(sleepMillis);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                throw e;
                if (retryTimes++ < this.maxRetryTimes) continue;
                log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                throw new WxRuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T, E> T executeInternal(RequestExecutor<T, E> executor, String uri, E data, boolean doNotAutoRefreshToken, boolean printResult) throws WxErrorException {
        Object dataForLog = DataUtils.handleDataWithSecret(data);
        if (uri.contains("access_token=")) {
            throw new IllegalArgumentException("uri\u53c2\u6570\u4e2d\u4e0d\u5141\u8bb8\u6709access_token: " + uri);
        }
        String accessToken = this.getAccessToken(false);
        WxChannelConfig config = this.getConfig();
        if (StringUtils.isNotEmpty((CharSequence)config.getApiHostUrl())) {
            uri = uri.replace("https://api.weixin.qq.com", config.getApiHostUrl());
        }
        String uriWithAccessToken = uri + (uri.contains("?") ? "&" : "?") + "access_token=" + accessToken;
        try {
            Object result = executor.execute(uriWithAccessToken, data, WxType.Channel);
            log.debug("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, printResult ? result : "..."});
            return (T)result;
        }
        catch (WxErrorException e) {
            WxError error = e.getError();
            if (WxConsts.ACCESS_TOKEN_ERROR_CODES.contains(error.getErrorCode())) {
                Lock lock = config.getAccessTokenLock();
                lock.lock();
                try {
                    if (StringUtils.equals((CharSequence)config.getAccessToken(), (CharSequence)accessToken)) {
                        config.expireAccessToken();
                    }
                }
                catch (Exception ex) {
                    config.expireAccessToken();
                }
                finally {
                    lock.unlock();
                }
                if (config.autoRefreshToken() && !doNotAutoRefreshToken) {
                    log.warn("\u5373\u5c06\u91cd\u65b0\u83b7\u53d6\u65b0\u7684access_token\uff0c\u9519\u8bef\u4ee3\u7801\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)error.getErrorCode(), (Object)error.getErrorMsg());
                    return this.executeInternal(executor, uri, data, true, printResult);
                }
            }
            if (error.getErrorCode() != 0) {
                log.warn("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u9519\u8bef\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, error});
                throw new WxErrorException(error, (Throwable)e);
            }
            return null;
        }
        catch (IOException e) {
            log.warn("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, e.getMessage()});
            throw new WxRuntimeException((Throwable)e);
        }
    }

    protected String extractAccessToken(String resultContent) throws WxErrorException {
        log.info("resultContent: " + resultContent);
        WxChannelConfig config = this.getConfig();
        WxError error = WxError.fromJson((String)resultContent, (WxType)WxType.MiniApp);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        WxAccessToken accessToken = WxAccessToken.fromJson((String)resultContent);
        config.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
        return accessToken.getAccessToken();
    }

    @Override
    public WxChannelConfig getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(WxChannelConfig config) {
        this.config = config;
        this.initHttp();
    }

    @Override
    public void setRetrySleepMillis(int retrySleepMillis) {
        this.retrySleepMillis = retrySleepMillis;
    }

    @Override
    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    @Override
    public WxChannelBasicService getBasicService() {
        return this.basicService;
    }

    @Override
    public WxChannelCategoryService getCategoryService() {
        return this.categoryService;
    }

    @Override
    public WxChannelBrandService getBrandService() {
        return this.brandService;
    }

    @Override
    public WxChannelProductService getProductService() {
        return this.productService;
    }

    @Override
    public WxChannelWarehouseService getWarehouseService() {
        return this.warehouseService;
    }

    @Override
    public WxChannelOrderService getOrderService() {
        return this.orderService;
    }

    @Override
    public WxChannelAfterSaleService getAfterSaleService() {
        return this.afterSaleService;
    }

    @Override
    public WxChannelFreightTemplateService getFreightTemplateService() {
        return this.freightTemplateService;
    }

    @Override
    public WxChannelAddressService getAddressService() {
        return this.addressService;
    }

    @Override
    public WxChannelCouponService getCouponService() {
        return this.couponService;
    }

    @Override
    public WxChannelSharerService getSharerService() {
        return this.sharerService;
    }

    @Override
    public WxChannelFundService getFundService() {
        return this.fundService;
    }

    @Override
    public synchronized WxLeagueWindowService getLeagueWindowService() {
        if (this.leagueWindowService == null) {
            this.leagueWindowService = new WxLeagueWindowServiceImpl(this);
        }
        return this.leagueWindowService;
    }

    @Override
    public synchronized WxLeagueSupplierService getLeagueSupplierService() {
        if (this.leagueSupplierService == null) {
            this.leagueSupplierService = new WxLeagueSupplierServiceImpl(this);
        }
        return this.leagueSupplierService;
    }

    @Override
    public synchronized WxLeaguePromoterService getLeaguePromoterService() {
        if (this.leaguePromoterService == null) {
            this.leaguePromoterService = new WxLeaguePromoterServiceImpl(this);
        }
        return this.leaguePromoterService;
    }

    @Override
    public synchronized WxLeagueProductService getLeagueProductService() {
        if (this.leagueProductService == null) {
            this.leagueProductService = new WxLeagueProductServiceImpl(this);
        }
        return this.leagueProductService;
    }
}

