/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.api.impl;

import me.chanjar.weixin.channel.api.WxChannelAddressService;
import me.chanjar.weixin.channel.api.impl.BaseWxChannelServiceImpl;
import me.chanjar.weixin.channel.bean.address.AddressAddParam;
import me.chanjar.weixin.channel.bean.address.AddressDetail;
import me.chanjar.weixin.channel.bean.address.AddressIdParam;
import me.chanjar.weixin.channel.bean.address.AddressIdResponse;
import me.chanjar.weixin.channel.bean.address.AddressInfoResponse;
import me.chanjar.weixin.channel.bean.address.AddressListParam;
import me.chanjar.weixin.channel.bean.address.AddressListResponse;
import me.chanjar.weixin.channel.bean.base.WxChannelBaseResponse;
import me.chanjar.weixin.channel.util.ResponseUtils;
import me.chanjar.weixin.common.error.WxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxChannelAddressServiceImpl
implements WxChannelAddressService {
    private static final Logger log = LoggerFactory.getLogger(WxChannelAddressServiceImpl.class);
    private final BaseWxChannelServiceImpl shopService;

    public WxChannelAddressServiceImpl(BaseWxChannelServiceImpl shopService) {
        this.shopService = shopService;
    }

    @Override
    public AddressListResponse listAddress(Integer offset, Integer limit) throws WxErrorException {
        AddressListParam param = new AddressListParam(offset, limit);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/merchant/address/list", param);
        return ResponseUtils.decode(resJson, AddressListResponse.class);
    }

    @Override
    public AddressInfoResponse getAddress(String addressId) throws WxErrorException {
        AddressIdParam param = new AddressIdParam(addressId);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/merchant/address/get", param);
        return ResponseUtils.decode(resJson, AddressInfoResponse.class);
    }

    @Override
    public AddressIdResponse addAddress(AddressDetail addressDetail) throws WxErrorException {
        AddressAddParam param = new AddressAddParam(addressDetail);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/merchant/address/add", param);
        return ResponseUtils.decode(resJson, AddressIdResponse.class);
    }

    @Override
    public WxChannelBaseResponse updateAddress(AddressDetail addressDetail) throws WxErrorException {
        AddressAddParam param = new AddressAddParam(addressDetail);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/merchant/address/update", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WxChannelBaseResponse deleteAddress(String addressId) throws WxErrorException {
        AddressIdParam param = new AddressIdParam(addressId);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/merchant/address/delete", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }
}

