/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.api.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import me.chanjar.weixin.channel.api.WxChannelBasicService;
import me.chanjar.weixin.channel.api.impl.BaseWxChannelServiceImpl;
import me.chanjar.weixin.channel.bean.address.AddressCodeResponse;
import me.chanjar.weixin.channel.bean.image.ChannelImageInfo;
import me.chanjar.weixin.channel.bean.image.ChannelImageResponse;
import me.chanjar.weixin.channel.bean.image.QualificationFileResponse;
import me.chanjar.weixin.channel.bean.image.UploadImageResponse;
import me.chanjar.weixin.channel.bean.shop.ShopInfoResponse;
import me.chanjar.weixin.channel.executor.ChannelFileUploadRequestExecutor;
import me.chanjar.weixin.channel.executor.ChannelMediaDownloadRequestExecutor;
import me.chanjar.weixin.channel.util.ResponseUtils;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxChannelBasicServiceImpl
implements WxChannelBasicService {
    private static final Logger log = LoggerFactory.getLogger(WxChannelBasicServiceImpl.class);
    private final BaseWxChannelServiceImpl shopService;

    public WxChannelBasicServiceImpl(BaseWxChannelServiceImpl shopService) {
        this.shopService = shopService;
    }

    @Override
    public ShopInfoResponse getShopInfo() throws WxErrorException {
        String resJson = this.shopService.get("https://api.weixin.qq.com/channels/ec/basics/info/get", null);
        return ResponseUtils.decode(resJson, ShopInfoResponse.class);
    }

    @Override
    public ChannelImageInfo uploadImg(int respType, String imgUrl) throws WxErrorException {
        String url = "https://api.weixin.qq.com/channels/ec/basics/img/upload?upload_type=1&resp_type=" + respType;
        String reqJson = "{\"img_url\":\"" + imgUrl + "\"}";
        String resJson = this.shopService.post(url, reqJson);
        UploadImageResponse response = ResponseUtils.decode(resJson, UploadImageResponse.class);
        return response.getImgInfo();
    }

    @Override
    public ChannelImageInfo uploadImg(int respType, File file, int height, int width) throws WxErrorException {
        String url = "https://api.weixin.qq.com/channels/ec/basics/img/upload?upload_type=0&resp_type=" + respType + "&height=" + height + "&width=" + width;
        RequestExecutor<String, File> executor = ChannelFileUploadRequestExecutor.create(this.shopService);
        String resJson = this.shopService.execute(executor, url, file);
        UploadImageResponse response = ResponseUtils.decode(resJson, UploadImageResponse.class);
        return response.getImgInfo();
    }

    @Override
    public QualificationFileResponse uploadQualificationFile(File file) throws WxErrorException {
        RequestExecutor<String, File> executor = ChannelFileUploadRequestExecutor.create(this.shopService);
        String resJson = this.shopService.execute(executor, "https://api.weixin.qq.com/channels/ec/basics/qualification/upload", file);
        return ResponseUtils.decode(resJson, QualificationFileResponse.class);
    }

    @Override
    public ChannelImageResponse getImg(String mediaId) throws WxErrorException {
        String appId = this.shopService.getConfig().getAppid();
        ChannelImageResponse rs = null;
        try {
            String url = "https://api.weixin.qq.com/channels/ec/basics/media/get?media_id=" + mediaId;
            RequestExecutor<ChannelImageResponse, String> executor = ChannelMediaDownloadRequestExecutor.create(this.shopService, Files.createTempDirectory("wxjava-channel-" + appId, new FileAttribute[0]).toFile());
            rs = this.shopService.execute(executor, url, null);
        }
        catch (IOException e) {
            throw new WxErrorException(WxError.builder().errorMsg(e.getMessage()).build(), (Throwable)e);
        }
        if (rs == null) {
            rs = ResponseUtils.internalError(ChannelImageResponse.class);
        }
        return rs;
    }

    @Override
    public AddressCodeResponse getAddressCode(Integer code) throws WxErrorException {
        String reqJson = "{\"addr_code\": " + code + "}";
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/basics/addresscode/get", reqJson);
        return ResponseUtils.decode(resJson, AddressCodeResponse.class);
    }
}

