/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.api.impl;

import me.chanjar.weixin.channel.api.WxChannelBrandService;
import me.chanjar.weixin.channel.api.impl.BaseWxChannelServiceImpl;
import me.chanjar.weixin.channel.bean.audit.AuditApplyResponse;
import me.chanjar.weixin.channel.bean.base.StreamPageParam;
import me.chanjar.weixin.channel.bean.base.WxChannelBaseResponse;
import me.chanjar.weixin.channel.bean.brand.Brand;
import me.chanjar.weixin.channel.bean.brand.BrandApplyListResponse;
import me.chanjar.weixin.channel.bean.brand.BrandInfoResponse;
import me.chanjar.weixin.channel.bean.brand.BrandListResponse;
import me.chanjar.weixin.channel.bean.brand.BrandParam;
import me.chanjar.weixin.channel.bean.brand.BrandSearchParam;
import me.chanjar.weixin.channel.util.ResponseUtils;
import me.chanjar.weixin.common.error.WxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxChannelBrandServiceImpl
implements WxChannelBrandService {
    private static final Logger log = LoggerFactory.getLogger(WxChannelBrandServiceImpl.class);
    private final BaseWxChannelServiceImpl shopService;

    public WxChannelBrandServiceImpl(BaseWxChannelServiceImpl shopService) {
        this.shopService = shopService;
    }

    @Override
    public BrandListResponse listAllBrand(Integer pageSize, String nextKey) throws WxErrorException {
        StreamPageParam param = new StreamPageParam(pageSize, nextKey);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/brand/all", param);
        return ResponseUtils.decode(resJson, BrandListResponse.class);
    }

    @Override
    public AuditApplyResponse addBrandApply(Brand brand) throws WxErrorException {
        BrandParam param = new BrandParam(brand);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/brand/add", param);
        return ResponseUtils.decode(resJson, AuditApplyResponse.class);
    }

    @Override
    public AuditApplyResponse updateBrandApply(Brand brand) throws WxErrorException {
        BrandParam param = new BrandParam(brand);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/brand/update", param);
        return ResponseUtils.decode(resJson, AuditApplyResponse.class);
    }

    @Override
    public WxChannelBaseResponse cancelBrandApply(String brandId, String auditId) throws WxErrorException {
        String reqJson = "{\"brand_id\":\"" + brandId + "\",\"audit_id\":\"" + auditId + "\"}";
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/brand/audit/cancel", reqJson);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WxChannelBaseResponse deleteBrandApply(String brandId) throws WxErrorException {
        String reqJson = "{\"brand_id\":\"" + brandId + "\"}";
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/brand/delete", reqJson);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public BrandInfoResponse getBrandApply(String brandId) throws WxErrorException {
        String reqJson = "{\"brand_id\":\"" + brandId + "\"}";
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/brand/get", reqJson);
        return ResponseUtils.decode(resJson, BrandInfoResponse.class);
    }

    @Override
    public BrandApplyListResponse listBrandApply(Integer pageSize, String nextKey, Integer status) throws WxErrorException {
        BrandSearchParam param = new BrandSearchParam(pageSize, nextKey, status);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/brand/list/get", param);
        return ResponseUtils.decode(resJson, BrandApplyListResponse.class);
    }

    @Override
    public BrandApplyListResponse listValidBrandApply(Integer pageSize, String nextKey) throws WxErrorException {
        StreamPageParam param = new StreamPageParam(pageSize, nextKey);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/brand/valid/list/get", param);
        return ResponseUtils.decode(resJson, BrandApplyListResponse.class);
    }
}

