/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.api.impl;

import me.chanjar.weixin.channel.api.WxChannelCouponService;
import me.chanjar.weixin.channel.api.impl.BaseWxChannelServiceImpl;
import me.chanjar.weixin.channel.bean.base.WxChannelBaseResponse;
import me.chanjar.weixin.channel.bean.coupon.CouponIdInfo;
import me.chanjar.weixin.channel.bean.coupon.CouponIdResponse;
import me.chanjar.weixin.channel.bean.coupon.CouponInfoResponse;
import me.chanjar.weixin.channel.bean.coupon.CouponListParam;
import me.chanjar.weixin.channel.bean.coupon.CouponListResponse;
import me.chanjar.weixin.channel.bean.coupon.CouponParam;
import me.chanjar.weixin.channel.bean.coupon.CouponStatusParam;
import me.chanjar.weixin.channel.bean.coupon.UserCouponIdParam;
import me.chanjar.weixin.channel.bean.coupon.UserCouponListParam;
import me.chanjar.weixin.channel.bean.coupon.UserCouponListResponse;
import me.chanjar.weixin.channel.bean.coupon.UserCouponResponse;
import me.chanjar.weixin.channel.util.ResponseUtils;
import me.chanjar.weixin.common.error.WxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxChannelCouponServiceImpl
implements WxChannelCouponService {
    private static final Logger log = LoggerFactory.getLogger(WxChannelCouponServiceImpl.class);
    private final BaseWxChannelServiceImpl shopService;

    public WxChannelCouponServiceImpl(BaseWxChannelServiceImpl shopService) {
        this.shopService = shopService;
    }

    @Override
    public CouponIdResponse createCoupon(CouponParam coupon) throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/coupon/create", coupon);
        return ResponseUtils.decode(resJson, CouponIdResponse.class);
    }

    @Override
    public CouponIdResponse updateCoupon(CouponParam coupon) throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/coupon/update", coupon);
        return ResponseUtils.decode(resJson, CouponIdResponse.class);
    }

    @Override
    public WxChannelBaseResponse updateCouponStatus(String couponId, Integer status) throws WxErrorException {
        CouponStatusParam param = new CouponStatusParam(couponId, status);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/coupon/update_status", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public CouponInfoResponse getCoupon(String couponId) throws WxErrorException {
        CouponIdInfo param = new CouponIdInfo(couponId);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/coupon/get", param);
        return ResponseUtils.decode(resJson, CouponInfoResponse.class);
    }

    @Override
    public CouponListResponse getCouponList(CouponListParam param) throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/coupon/get_list", param);
        return ResponseUtils.decode(resJson, CouponListResponse.class);
    }

    @Override
    public UserCouponResponse getUserCoupon(String openId, String userCouponId) throws WxErrorException {
        UserCouponIdParam param = new UserCouponIdParam(openId, userCouponId);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/coupon/get_user_coupon", param);
        return ResponseUtils.decode(resJson, UserCouponResponse.class);
    }

    @Override
    public UserCouponListResponse getUserCouponList(UserCouponListParam param) throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/coupon/get_user_coupon_list", param);
        return ResponseUtils.decode(resJson, UserCouponListResponse.class);
    }
}

