/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.api.impl;

import me.chanjar.weixin.channel.api.WxChannelFreightTemplateService;
import me.chanjar.weixin.channel.api.impl.BaseWxChannelServiceImpl;
import me.chanjar.weixin.channel.bean.freight.FreightTemplate;
import me.chanjar.weixin.channel.bean.freight.TemplateAddParam;
import me.chanjar.weixin.channel.bean.freight.TemplateIdResponse;
import me.chanjar.weixin.channel.bean.freight.TemplateInfoResponse;
import me.chanjar.weixin.channel.bean.freight.TemplateListParam;
import me.chanjar.weixin.channel.bean.freight.TemplateListResponse;
import me.chanjar.weixin.channel.util.ResponseUtils;
import me.chanjar.weixin.common.error.WxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxChannelFreightTemplateServiceImpl
implements WxChannelFreightTemplateService {
    private static final Logger log = LoggerFactory.getLogger(WxChannelFreightTemplateServiceImpl.class);
    private final BaseWxChannelServiceImpl shopService;

    public WxChannelFreightTemplateServiceImpl(BaseWxChannelServiceImpl shopService) {
        this.shopService = shopService;
    }

    @Override
    public TemplateListResponse listTemplate(Integer offset, Integer limit) throws WxErrorException {
        TemplateListParam param = new TemplateListParam(offset, limit);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/merchant/getfreighttemplatelist", param);
        return ResponseUtils.decode(resJson, TemplateListResponse.class);
    }

    @Override
    public TemplateInfoResponse getTemplate(String templateId) throws WxErrorException {
        String reqJson = "{\"template_id\": \"" + templateId + "\"}";
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/merchant/getfreighttemplatedetail", reqJson);
        return ResponseUtils.decode(resJson, TemplateInfoResponse.class);
    }

    @Override
    public TemplateIdResponse addTemplate(FreightTemplate template) throws WxErrorException {
        TemplateAddParam param = new TemplateAddParam(template);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/merchant/addfreighttemplate", param);
        return ResponseUtils.decode(resJson, TemplateIdResponse.class);
    }

    @Override
    public TemplateIdResponse updateTemplate(FreightTemplate template) throws WxErrorException {
        TemplateAddParam param = new TemplateAddParam(template);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/merchant/updatefreighttemplate", param);
        return ResponseUtils.decode(resJson, TemplateIdResponse.class);
    }
}

