/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.api.impl;

import java.util.List;
import me.chanjar.weixin.channel.api.WxChannelWarehouseService;
import me.chanjar.weixin.channel.api.impl.BaseWxChannelServiceImpl;
import me.chanjar.weixin.channel.bean.base.StreamPageParam;
import me.chanjar.weixin.channel.bean.base.WxChannelBaseResponse;
import me.chanjar.weixin.channel.bean.warehouse.LocationPriorityResponse;
import me.chanjar.weixin.channel.bean.warehouse.PriorityLocationParam;
import me.chanjar.weixin.channel.bean.warehouse.StockGetParam;
import me.chanjar.weixin.channel.bean.warehouse.UpdateLocationParam;
import me.chanjar.weixin.channel.bean.warehouse.WarehouseIdsResponse;
import me.chanjar.weixin.channel.bean.warehouse.WarehouseLocation;
import me.chanjar.weixin.channel.bean.warehouse.WarehouseLocationParam;
import me.chanjar.weixin.channel.bean.warehouse.WarehouseParam;
import me.chanjar.weixin.channel.bean.warehouse.WarehouseResponse;
import me.chanjar.weixin.channel.bean.warehouse.WarehouseStockParam;
import me.chanjar.weixin.channel.bean.warehouse.WarehouseStockResponse;
import me.chanjar.weixin.channel.util.ResponseUtils;
import me.chanjar.weixin.common.error.WxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxChannelWarehouseServiceImpl
implements WxChannelWarehouseService {
    private static final Logger log = LoggerFactory.getLogger(WxChannelWarehouseServiceImpl.class);
    private final BaseWxChannelServiceImpl shopService;

    public WxChannelWarehouseServiceImpl(BaseWxChannelServiceImpl shopService) {
        this.shopService = shopService;
    }

    @Override
    public WxChannelBaseResponse createWarehouse(WarehouseParam param) throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/warehouse/create", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WarehouseIdsResponse listWarehouse(Integer pageSize, String nextKey) throws WxErrorException {
        StreamPageParam param = new StreamPageParam(pageSize, nextKey);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/warehouse/list/get", param);
        return ResponseUtils.decode(resJson, WarehouseIdsResponse.class);
    }

    @Override
    public WarehouseResponse getWarehouse(String outWarehouseId) throws WxErrorException {
        String reqJson = "{\"out_warehouse_id\":\"" + outWarehouseId + "\"}";
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/warehouse/get", reqJson);
        return ResponseUtils.decode(resJson, WarehouseResponse.class);
    }

    @Override
    public WxChannelBaseResponse updateWarehouse(String outWarehouseId, String name, String intro) throws WxErrorException {
        String reqJson = "{\"out_warehouse_id\":\"" + outWarehouseId + "\",\"name\":\"" + name + "\",\"intro\":\"" + intro + "\"}";
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/warehouse/detail/update", reqJson);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WxChannelBaseResponse addWarehouseArea(String outWarehouseId, List<WarehouseLocation> coverLocations) throws WxErrorException {
        UpdateLocationParam param = new UpdateLocationParam(outWarehouseId, coverLocations);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/warehouse/coverlocations/add", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WxChannelBaseResponse deleteWarehouseArea(String outWarehouseId, List<WarehouseLocation> coverLocations) throws WxErrorException {
        UpdateLocationParam param = new UpdateLocationParam(outWarehouseId, coverLocations);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/warehouse/coverlocations/del", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WxChannelBaseResponse setWarehousePriority(PriorityLocationParam param) throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/warehouse/address/prioritysort/set", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public LocationPriorityResponse getWarehousePriority(Integer addressId1, Integer addressId2, Integer addressId3, Integer addressId4) throws WxErrorException {
        WarehouseLocationParam param = new WarehouseLocationParam(addressId1, addressId2, addressId3, addressId4);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/warehouse/address/prioritysort/get", param);
        return ResponseUtils.decode(resJson, LocationPriorityResponse.class);
    }

    @Override
    public WxChannelBaseResponse updateWarehouseStock(WarehouseStockParam param) throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/warehouse/stock/update", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WarehouseStockResponse getWarehouseStock(String productId, String skuId, String outWarehouseId) throws WxErrorException {
        StockGetParam param = new StockGetParam(productId, skuId, outWarehouseId);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/warehouse/stock/get", param);
        return ResponseUtils.decode(resJson, WarehouseStockResponse.class);
    }
}

