/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.api.impl;

import me.chanjar.weixin.channel.api.WxLeaguePromoterService;
import me.chanjar.weixin.channel.api.impl.BaseWxChannelServiceImpl;
import me.chanjar.weixin.channel.bean.base.WxChannelBaseResponse;
import me.chanjar.weixin.channel.bean.league.promoter.PromoterInfoResponse;
import me.chanjar.weixin.channel.bean.league.promoter.PromoterListParam;
import me.chanjar.weixin.channel.bean.league.promoter.PromoterListResponse;
import me.chanjar.weixin.channel.util.ResponseUtils;
import me.chanjar.weixin.common.error.WxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxLeaguePromoterServiceImpl
implements WxLeaguePromoterService {
    private static final Logger log = LoggerFactory.getLogger(WxLeaguePromoterServiceImpl.class);
    private final BaseWxChannelServiceImpl shopService;

    public WxLeaguePromoterServiceImpl(BaseWxChannelServiceImpl shopService) {
        this.shopService = shopService;
    }

    @Override
    public WxChannelBaseResponse addPromoter(String finderId) throws WxErrorException {
        String reqJson = "{\"finder_id\":\"" + finderId + "\"}";
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/league/promoter/add", reqJson);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WxChannelBaseResponse updatePromoter(String finderId, int type) throws WxErrorException {
        String reqJson = "{\"finder_id\":\"" + finderId + "\",\"type\":" + type + "}";
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/league/promoter/upd", reqJson);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WxChannelBaseResponse deletePromoter(String finderId) throws WxErrorException {
        String reqJson = "{\"finder_id\":\"" + finderId + "\"}";
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/league/promoter/delete", reqJson);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public PromoterInfoResponse getPromoterInfo(String finderId) throws WxErrorException {
        String reqJson = "{\"finder_id\":\"" + finderId + "\"}";
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/league/promoter/get", reqJson);
        return ResponseUtils.decode(resJson, PromoterInfoResponse.class);
    }

    @Override
    public PromoterListResponse listPromoter(Integer pageIndex, Integer pageSize, Integer status) throws WxErrorException {
        PromoterListParam param = new PromoterListParam(pageIndex, pageSize, status);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/league/promoter/list/get", param);
        return ResponseUtils.decode(resJson, PromoterListResponse.class);
    }
}

