/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.enums;

public enum WxOrderStatus {
    UNPAID(10, "\u5f85\u4ed8\u6b3e"),
    PAID(20, "\u5f85\u53d1\u8d27"),
    PART_DELIVERY(21, "\u90e8\u5206\u53d1\u8d27"),
    DELIVERY(30, "\u5f85\u6536\u8d27"),
    COMPLETED(100, "\u5df2\u5b8c\u6210"),
    UNPAID_CANCEL(190, "\u5df2\u53d6\u6d88"),
    ALL_AFTER_SALE(200, "\u5df2\u53d6\u6d88"),
    CANCEL(250, "\u5df2\u53d6\u6d88");

    private final int key;
    private final String val;

    private WxOrderStatus(int key, String val) {
        this.key = key;
        this.val = val;
    }

    public int getKey() {
        return this.key;
    }

    public String getVal() {
        return this.val;
    }

    public static String getStatusStr(Integer key) {
        if (key == null) {
            return "\u672a\u77e5";
        }
        for (WxOrderStatus status : WxOrderStatus.values()) {
            if (!key.equals(status.getKey())) continue;
            return status.getVal();
        }
        return String.valueOf(key);
    }

    public static boolean isCancel(Integer key) {
        if (key == null) {
            return false;
        }
        return key.equals(WxOrderStatus.UNPAID_CANCEL.key) || key.equals(WxOrderStatus.ALL_AFTER_SALE.key) || key.equals(WxOrderStatus.CANCEL.key);
    }
}

