/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.executor;

import java.io.File;
import java.io.IOException;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.ResponseHandler;
import me.chanjar.weixin.common.util.http.apache.Utf8ResponseHandler;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;

public class ChannelFileUploadRequestExecutor
implements RequestExecutor<String, File> {
    protected RequestHttp<CloseableHttpClient, HttpHost> requestHttp;

    public ChannelFileUploadRequestExecutor(RequestHttp<CloseableHttpClient, HttpHost> requestHttp) {
        this.requestHttp = requestHttp;
    }

    /*
     * Loose catch block
     */
    public String execute(String uri, File file, WxType wxType) throws WxErrorException, IOException {
        HttpPost httpPost = new HttpPost(uri);
        if (this.requestHttp.getRequestHttpProxy() != null) {
            RequestConfig config = RequestConfig.custom().setProxy((HttpHost)this.requestHttp.getRequestHttpProxy()).build();
            httpPost.setConfig(config);
        }
        if (file != null) {
            HttpEntity entity = MultipartEntityBuilder.create().addBinaryBody("media", file).setMode(HttpMultipartMode.RFC6532).build();
            httpPost.setEntity(entity);
        }
        try {
            try (CloseableHttpResponse response = ((CloseableHttpClient)this.requestHttp.getRequestHttpClient()).execute((HttpUriRequest)httpPost);){
                String string = (String)Utf8ResponseHandler.INSTANCE.handleResponse((HttpResponse)response);
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            httpPost.releaseConnection();
        }
    }

    public void execute(String uri, File data, ResponseHandler<String> handler, WxType wxType) throws WxErrorException, IOException {
        handler.handle((Object)this.execute(uri, data, wxType));
    }

    public static RequestExecutor<String, File> create(RequestHttp<CloseableHttpClient, HttpHost> requestHttp) {
        return new ChannelFileUploadRequestExecutor(requestHttp);
    }
}

