/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.message;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import me.chanjar.weixin.channel.api.WxChannelService;
import me.chanjar.weixin.channel.message.WxChannelMessage;
import me.chanjar.weixin.channel.message.WxChannelMessageRouterRule;
import me.chanjar.weixin.common.api.WxErrorExceptionHandler;
import me.chanjar.weixin.common.api.WxMessageDuplicateChecker;
import me.chanjar.weixin.common.api.WxMessageInMemoryDuplicateCheckerSingleton;
import me.chanjar.weixin.common.session.InternalSession;
import me.chanjar.weixin.common.session.InternalSessionManager;
import me.chanjar.weixin.common.session.StandardSessionManager;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.common.util.LogExceptionHandler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxChannelMessageRouter {
    private static final Logger log = LoggerFactory.getLogger(WxChannelMessageRouter.class);
    private final List<WxChannelMessageRouterRule<? extends WxChannelMessage>> rules = new ArrayList<WxChannelMessageRouterRule<? extends WxChannelMessage>>();
    private ExecutorService executorService;
    private WxErrorExceptionHandler exceptionHandler;
    private WxMessageDuplicateChecker messageDuplicateChecker;

    public WxChannelMessageRouter() {
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("WxChMsgRouter-pool-%d").build();
        this.executorService = new ThreadPoolExecutor(2, 100, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
        this.exceptionHandler = new LogExceptionHandler();
        this.messageDuplicateChecker = WxMessageInMemoryDuplicateCheckerSingleton.getInstance();
    }

    public WxChannelMessageRouter(ExecutorService executorService) {
        this.executorService = executorService;
        this.exceptionHandler = new LogExceptionHandler();
        this.messageDuplicateChecker = WxMessageInMemoryDuplicateCheckerSingleton.getInstance();
    }

    public void shutDownExecutorService() {
        this.executorService.shutdown();
    }

    public void shutDownExecutorService(Integer second) {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(second.intValue(), TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
                if (!this.executorService.awaitTermination(second.intValue(), TimeUnit.SECONDS)) {
                    log.error("\u7ebf\u7a0b\u6c60\u672a\u5173\u95ed\uff01");
                }
            }
        }
        catch (InterruptedException ie) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public Object route(WxChannelMessage message, String content, String appId, WxChannelService service) {
        return this.route(message, content, appId, new HashMap<String, Object>(2), service, (WxSessionManager)new StandardSessionManager());
    }

    public Object route(WxChannelMessage message, String content, String appId, Map<String, Object> context, WxChannelService service, WxSessionManager sessionManager) {
        if (this.isMsgDuplicated(message)) {
            return null;
        }
        ArrayList<WxChannelMessageRouterRule<? extends WxChannelMessage>> matchRules = new ArrayList<WxChannelMessageRouterRule<? extends WxChannelMessage>>();
        for (WxChannelMessageRouterRule<? extends WxChannelMessage> rule : this.rules) {
            if (!rule.isMatch(message)) continue;
            matchRules.add(rule);
            if (rule.isNext()) continue;
            break;
        }
        if (matchRules.size() == 0) {
            return null;
        }
        ArrayList futures = new ArrayList();
        Object result = null;
        for (WxChannelMessageRouterRule wxChannelMessageRouterRule : matchRules) {
            if (wxChannelMessageRouterRule.isAsync()) {
                futures.add(this.executorService.submit(() -> rule.process(message, content, appId, context, service, sessionManager, this.exceptionHandler)));
                continue;
            }
            result = wxChannelMessageRouterRule.process(message, content, appId, context, service, sessionManager, this.exceptionHandler);
            this.sessionEndAccess(sessionManager, message, false);
        }
        if (futures.size() > 0) {
            this.executorService.submit(() -> {
                for (Future future : futures) {
                    try {
                        future.get();
                        this.sessionEndAccess(sessionManager, message, true);
                    }
                    catch (InterruptedException | ExecutionException e) {
                        log.error("Error happened when wait task finish", (Throwable)e);
                    }
                }
            });
        }
        return result;
    }

    private boolean isMsgDuplicated(WxChannelMessage wxMessage) {
        String messageId = this.generateMessageId(wxMessage);
        return this.messageDuplicateChecker.isDuplicate(messageId);
    }

    private String generateMessageId(WxChannelMessage wxMessage) {
        StringBuilder sb = new StringBuilder();
        if (wxMessage.getMsgId() == null) {
            sb.append(wxMessage.getCreateTime()).append("-").append(wxMessage.getFromUser()).append("-").append(StringUtils.trimToEmpty((String)wxMessage.getEvent()));
        } else {
            sb.append(wxMessage.getMsgId()).append("-").append(wxMessage.getCreateTime()).append("-").append(wxMessage.getFromUser());
        }
        if (StringUtils.isNotEmpty((CharSequence)wxMessage.getToUser())) {
            sb.append("-").append(wxMessage.getToUser());
        }
        return sb.toString();
    }

    private void sessionEndAccess(WxSessionManager sessionManager, WxChannelMessage message, boolean sync) {
        log.debug("End session access: async={}, sessionId={}", (Object)sync, (Object)message.getFromUser());
        InternalSession session = ((InternalSessionManager)sessionManager).findSession(message.getFromUser());
        if (session != null) {
            session.endAccess();
        }
    }

    public List<WxChannelMessageRouterRule<? extends WxChannelMessage>> getRules() {
        return this.rules;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public WxErrorExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public WxMessageDuplicateChecker getMessageDuplicateChecker() {
        return this.messageDuplicateChecker;
    }

    public void setExceptionHandler(WxErrorExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setMessageDuplicateChecker(WxMessageDuplicateChecker messageDuplicateChecker) {
        this.messageDuplicateChecker = messageDuplicateChecker;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxChannelMessageRouter)) {
            return false;
        }
        WxChannelMessageRouter other = (WxChannelMessageRouter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<WxChannelMessageRouterRule<? extends WxChannelMessage>> this$rules = this.getRules();
        List<WxChannelMessageRouterRule<? extends WxChannelMessage>> other$rules = other.getRules();
        if (this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules)) {
            return false;
        }
        ExecutorService this$executorService = this.getExecutorService();
        ExecutorService other$executorService = other.getExecutorService();
        if (this$executorService == null ? other$executorService != null : !this$executorService.equals(other$executorService)) {
            return false;
        }
        WxErrorExceptionHandler this$exceptionHandler = this.getExceptionHandler();
        WxErrorExceptionHandler other$exceptionHandler = other.getExceptionHandler();
        if (this$exceptionHandler == null ? other$exceptionHandler != null : !this$exceptionHandler.equals(other$exceptionHandler)) {
            return false;
        }
        WxMessageDuplicateChecker this$messageDuplicateChecker = this.getMessageDuplicateChecker();
        WxMessageDuplicateChecker other$messageDuplicateChecker = other.getMessageDuplicateChecker();
        return !(this$messageDuplicateChecker == null ? other$messageDuplicateChecker != null : !this$messageDuplicateChecker.equals(other$messageDuplicateChecker));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxChannelMessageRouter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<WxChannelMessageRouterRule<? extends WxChannelMessage>> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        ExecutorService $executorService = this.getExecutorService();
        result = result * 59 + ($executorService == null ? 43 : $executorService.hashCode());
        WxErrorExceptionHandler $exceptionHandler = this.getExceptionHandler();
        result = result * 59 + ($exceptionHandler == null ? 43 : $exceptionHandler.hashCode());
        WxMessageDuplicateChecker $messageDuplicateChecker = this.getMessageDuplicateChecker();
        result = result * 59 + ($messageDuplicateChecker == null ? 43 : $messageDuplicateChecker.hashCode());
        return result;
    }

    public String toString() {
        return "WxChannelMessageRouter(rules=" + this.getRules() + ", executorService=" + this.getExecutorService() + ", exceptionHandler=" + this.getExceptionHandler() + ", messageDuplicateChecker=" + this.getMessageDuplicateChecker() + ")";
    }
}

