/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static final JsonMapper JSON_MAPPER = new JsonMapper();

    private JsonUtils() {
    }

    public static String encode(Object obj) {
        try {
            return JSON_MAPPER.writeValueAsString(obj);
        }
        catch (IOException e) {
            log.error("encode(Object)", (Throwable)e);
            return null;
        }
    }

    public static String encode(ObjectMapper objectMapper, Object obj) {
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (IOException e) {
            log.error("encode(Object)", (Throwable)e);
            return null;
        }
    }

    public static <T> T decode(String json, Class<T> valueType) {
        if (json == null || json.length() <= 0) {
            return null;
        }
        try {
            return (T)JSON_MAPPER.readValue(json, valueType);
        }
        catch (IOException e) {
            log.info("decode(String, Class<T>)", (Throwable)e);
            return null;
        }
    }

    public static <T> T decode(String json, TypeReference<T> typeReference) {
        try {
            return (T)JSON_MAPPER.readValue(json, typeReference);
        }
        catch (IOException e) {
            log.info("decode(String, JsonTypeReference<T>)", (Throwable)e);
            return null;
        }
    }

    static {
        JSON_MAPPER.enable(new JsonParser.Feature[]{JsonReadFeature.ALLOW_JAVA_COMMENTS.mappedFeature()});
        JSON_MAPPER.enable(new JsonParser.Feature[]{JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES.mappedFeature()});
        JSON_MAPPER.enable(new JsonParser.Feature[]{JsonReadFeature.ALLOW_SINGLE_QUOTES.mappedFeature()});
        JSON_MAPPER.enable(new JsonParser.Feature[]{JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature()});
        JSON_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        JSON_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        JSON_MAPPER.disable(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES);
    }
}

