/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlUtils {
    private static final Logger log = LoggerFactory.getLogger(XmlUtils.class);
    private static final XmlMapper XML_MAPPER = new XmlMapper();

    private XmlUtils() {
    }

    public static String encode(Object obj) {
        try {
            return XML_MAPPER.writeValueAsString(obj);
        }
        catch (IOException e) {
            log.error("encode(Object)", (Throwable)e);
            return null;
        }
    }

    public static String encode(ObjectMapper objectMapper, Object obj) {
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (IOException e) {
            log.error("encode(Object)", (Throwable)e);
            return null;
        }
    }

    public static <T> T decode(String xml, Class<T> valueType) {
        if (xml == null || xml.length() <= 0) {
            return null;
        }
        try {
            return (T)XML_MAPPER.readValue(xml, valueType);
        }
        catch (IOException e) {
            log.info("decode(String, Class<T>)", (Throwable)e);
            return null;
        }
    }

    public static <T> T decode(String xml, TypeReference<T> typeReference) {
        try {
            return (T)XML_MAPPER.readValue(xml, typeReference);
        }
        catch (IOException e) {
            log.info("decode(String, TypeReference<T>)", (Throwable)e);
            return null;
        }
    }

    public static <T> T decode(InputStream is, Class<T> valueType) {
        try {
            return (T)XML_MAPPER.readValue(is, valueType);
        }
        catch (IOException e) {
            log.info("decode(InputStream, Class<T>)", (Throwable)e);
            return null;
        }
    }

    static {
        XML_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        XML_MAPPER.disable(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES);
        XML_MAPPER.disable(ToXmlGenerator.Feature.WRITE_XML_DECLARATION);
    }
}

