/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.api.impl;

import java.util.List;
import me.chanjar.weixin.channel.api.WxChannelAfterSaleService;
import me.chanjar.weixin.channel.api.impl.BaseWxChannelServiceImpl;
import me.chanjar.weixin.channel.bean.after.AfterSaleAcceptExchangeReshipParam;
import me.chanjar.weixin.channel.bean.after.AfterSaleAcceptParam;
import me.chanjar.weixin.channel.bean.after.AfterSaleIdParam;
import me.chanjar.weixin.channel.bean.after.AfterSaleInfoResponse;
import me.chanjar.weixin.channel.bean.after.AfterSaleListParam;
import me.chanjar.weixin.channel.bean.after.AfterSaleListResponse;
import me.chanjar.weixin.channel.bean.after.AfterSaleMerchantUpdateParam;
import me.chanjar.weixin.channel.bean.after.AfterSaleReasonResponse;
import me.chanjar.weixin.channel.bean.after.AfterSaleRejectExchangeReshipParam;
import me.chanjar.weixin.channel.bean.after.AfterSaleRejectParam;
import me.chanjar.weixin.channel.bean.after.AfterSaleRejectReasonResponse;
import me.chanjar.weixin.channel.bean.after.RefundEvidenceParam;
import me.chanjar.weixin.channel.bean.base.WxChannelBaseResponse;
import me.chanjar.weixin.channel.bean.complaint.ComplaintOrderResponse;
import me.chanjar.weixin.channel.bean.complaint.ComplaintParam;
import me.chanjar.weixin.channel.util.ResponseUtils;
import me.chanjar.weixin.common.error.WxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxChannelAfterSaleServiceImpl
implements WxChannelAfterSaleService {
    private static final Logger log = LoggerFactory.getLogger(WxChannelAfterSaleServiceImpl.class);
    private final BaseWxChannelServiceImpl<?, ?> shopService;

    public WxChannelAfterSaleServiceImpl(BaseWxChannelServiceImpl<?, ?> shopService) {
        this.shopService = shopService;
    }

    @Override
    public AfterSaleListResponse listIds(Long beginCreateTime, Long endCreateTime, String nextKey) throws WxErrorException {
        AfterSaleListParam param = new AfterSaleListParam(beginCreateTime, endCreateTime, null, null, nextKey);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/aftersale/getaftersalelist", param);
        return ResponseUtils.decode(resJson, AfterSaleListResponse.class);
    }

    @Override
    public AfterSaleListResponse listIds(AfterSaleListParam param) throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/aftersale/getaftersalelist", param);
        return ResponseUtils.decode(resJson, AfterSaleListResponse.class);
    }

    @Override
    public AfterSaleInfoResponse get(String afterSaleOrderId) throws WxErrorException {
        AfterSaleIdParam param = new AfterSaleIdParam(afterSaleOrderId);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/aftersale/getaftersaleorder", param);
        return ResponseUtils.decode(resJson, AfterSaleInfoResponse.class);
    }

    @Override
    public WxChannelBaseResponse accept(String afterSaleOrderId, String addressId, Integer acceptType) throws WxErrorException {
        AfterSaleAcceptParam param = new AfterSaleAcceptParam(afterSaleOrderId, addressId, acceptType);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/aftersale/acceptapply", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WxChannelBaseResponse reject(String afterSaleOrderId, String rejectReason, Integer rejectReasonType) throws WxErrorException {
        AfterSaleRejectParam param = new AfterSaleRejectParam(afterSaleOrderId, rejectReason, rejectReasonType);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/aftersale/rejectapply", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WxChannelBaseResponse uploadRefundEvidence(String afterSaleOrderId, String desc, List<String> certificates) throws WxErrorException {
        RefundEvidenceParam param = new RefundEvidenceParam(afterSaleOrderId, desc, certificates);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/aftersale/uploadrefundcertificate", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WxChannelBaseResponse addComplaintMaterial(String complaintId, String content, List<String> mediaIds) throws WxErrorException {
        ComplaintParam param = new ComplaintParam(complaintId, content, mediaIds);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/aftersale/addcomplaintmaterial", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WxChannelBaseResponse addComplaintEvidence(String complaintId, String content, List<String> mediaIds) throws WxErrorException {
        ComplaintParam param = new ComplaintParam(complaintId, content, mediaIds);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/aftersale/addcomplaintproof", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public ComplaintOrderResponse getComplaint(String complaintId) throws WxErrorException {
        String reqJson = "{\"complaint_id\":\"" + complaintId + "\"}";
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/aftersale/getcomplaintorder", reqJson);
        return ResponseUtils.decode(resJson, ComplaintOrderResponse.class);
    }

    @Override
    public AfterSaleReasonResponse getAllReason() throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/aftersale/reason/get", "{}");
        return ResponseUtils.decode(resJson, AfterSaleReasonResponse.class);
    }

    @Override
    public AfterSaleRejectReasonResponse getRejectReason() throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/aftersale/rejectreason/get", "{}");
        return ResponseUtils.decode(resJson, AfterSaleRejectReasonResponse.class);
    }

    @Override
    public WxChannelBaseResponse acceptExchangeReship(String afterSaleOrderId, String waybillId, String deliveryId) throws WxErrorException {
        AfterSaleAcceptExchangeReshipParam param = new AfterSaleAcceptExchangeReshipParam(afterSaleOrderId, waybillId, deliveryId);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/aftersale/acceptexchangereship", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WxChannelBaseResponse rejectExchangeReship(String afterSaleOrderId, String rejectReason, Integer rejectReasonType, List<String> rejectCertificates) throws WxErrorException {
        AfterSaleRejectExchangeReshipParam param = new AfterSaleRejectExchangeReshipParam(afterSaleOrderId, rejectReason, rejectReasonType, rejectCertificates);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/aftersale/rejectexchangereship", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WxChannelBaseResponse merchantUpdateAfterSale(AfterSaleMerchantUpdateParam param) throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/aftersale/merchantupdateaftersale", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }
}

