/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.api.impl;

import me.chanjar.weixin.channel.api.WxChannelCompassFinderService;
import me.chanjar.weixin.channel.api.impl.BaseWxChannelServiceImpl;
import me.chanjar.weixin.channel.bean.compass.CompassFinderBaseParam;
import me.chanjar.weixin.channel.bean.compass.finder.OverallResponse;
import me.chanjar.weixin.channel.bean.compass.finder.ProductDataParam;
import me.chanjar.weixin.channel.bean.compass.finder.ProductDataResponse;
import me.chanjar.weixin.channel.bean.compass.finder.ProductListResponse;
import me.chanjar.weixin.channel.bean.compass.finder.SaleProfileDataParam;
import me.chanjar.weixin.channel.bean.compass.finder.SaleProfileDataResponse;
import me.chanjar.weixin.channel.util.ResponseUtils;
import me.chanjar.weixin.common.error.WxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxChannelCompassFinderServiceImpl
implements WxChannelCompassFinderService {
    private static final Logger log = LoggerFactory.getLogger(WxChannelCompassFinderServiceImpl.class);
    private final BaseWxChannelServiceImpl<?, ?> shopService;

    public WxChannelCompassFinderServiceImpl(BaseWxChannelServiceImpl<?, ?> shopService) {
        this.shopService = shopService;
    }

    @Override
    public OverallResponse getOverall(String ds) throws WxErrorException {
        CompassFinderBaseParam param = new CompassFinderBaseParam(ds);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/compass/finder/overall/get", param);
        return ResponseUtils.decode(resJson, OverallResponse.class);
    }

    @Override
    public ProductDataResponse getProductData(String ds, String productId) throws WxErrorException {
        ProductDataParam param = new ProductDataParam(ds, productId);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/compass/finder/product/data/get", param);
        return ResponseUtils.decode(resJson, ProductDataResponse.class);
    }

    @Override
    public ProductListResponse getProductList(String ds) throws WxErrorException {
        CompassFinderBaseParam param = new CompassFinderBaseParam(ds);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/compass/finder/product/list/get", param);
        return ResponseUtils.decode(resJson, ProductListResponse.class);
    }

    @Override
    public SaleProfileDataResponse getSaleProfileData(String ds, Integer type) throws WxErrorException {
        SaleProfileDataParam param = new SaleProfileDataParam(ds, type);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/compass/finder/sale/profile/data/get", param);
        return ResponseUtils.decode(resJson, SaleProfileDataResponse.class);
    }
}

