/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.api.impl;

import java.io.IOException;
import me.chanjar.weixin.channel.api.impl.BaseWxChannelServiceImpl;
import me.chanjar.weixin.channel.bean.token.StableTokenParam;
import me.chanjar.weixin.channel.config.WxChannelConfig;
import me.chanjar.weixin.channel.util.JsonUtils;
import me.chanjar.weixin.common.util.http.HttpClientType;
import me.chanjar.weixin.common.util.http.apache.ApacheBasicResponseHandler;
import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientBuilder;
import me.chanjar.weixin.common.util.http.apache.DefaultApacheHttpClientBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxChannelServiceHttpClientImpl
extends BaseWxChannelServiceImpl<HttpClient, HttpHost> {
    private static final Logger log = LoggerFactory.getLogger(WxChannelServiceHttpClientImpl.class);
    private CloseableHttpClient httpClient;
    private HttpHost httpProxy;

    @Override
    public void initHttp() {
        WxChannelConfig config = this.getConfig();
        ApacheHttpClientBuilder apacheHttpClientBuilder = config.getApacheHttpClientBuilder();
        if (null == apacheHttpClientBuilder) {
            apacheHttpClientBuilder = DefaultApacheHttpClientBuilder.get();
        }
        apacheHttpClientBuilder.httpProxyHost(config.getHttpProxyHost()).httpProxyPort(config.getHttpProxyPort()).httpProxyUsername(config.getHttpProxyUsername()).httpProxyPassword(config.getHttpProxyPassword());
        if (config.getHttpProxyHost() != null && config.getHttpProxyPort() > 0) {
            this.httpProxy = new HttpHost(config.getHttpProxyHost(), config.getHttpProxyPort());
        }
        this.httpClient = apacheHttpClientBuilder.build();
    }

    public CloseableHttpClient getRequestHttpClient() {
        return this.httpClient;
    }

    public HttpHost getRequestHttpProxy() {
        return this.httpProxy;
    }

    public HttpClientType getRequestType() {
        return HttpClientType.APACHE_HTTP;
    }

    @Override
    protected String doGetAccessTokenRequest() throws IOException {
        WxChannelConfig config = this.getConfig();
        String url = StringUtils.isNotEmpty((CharSequence)config.getAccessTokenUrl()) ? config.getAccessTokenUrl() : (StringUtils.isNotEmpty((CharSequence)config.getApiHostUrl()) ? "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s".replace("https://api.weixin.qq.com", config.getApiHostUrl()) : "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s");
        url = String.format(url, config.getAppid(), config.getSecret());
        HttpGet httpGet = new HttpGet(url);
        if (this.getRequestHttpProxy() != null) {
            RequestConfig requestConfig = RequestConfig.custom().setProxy(this.getRequestHttpProxy()).build();
            httpGet.setConfig(requestConfig);
        }
        return (String)this.getRequestHttpClient().execute((HttpUriRequest)httpGet, (ResponseHandler)ApacheBasicResponseHandler.INSTANCE);
    }

    @Override
    protected String doGetStableAccessTokenRequest(boolean forceRefresh) throws IOException {
        WxChannelConfig config = this.getConfig();
        String url = "https://api.weixin.qq.com/cgi-bin/stable_token";
        HttpPost httpPost = new HttpPost(url);
        if (this.getRequestHttpProxy() != null) {
            RequestConfig requestConfig = RequestConfig.custom().setProxy(this.getRequestHttpProxy()).build();
            httpPost.setConfig(requestConfig);
        }
        StableTokenParam requestParam = new StableTokenParam();
        requestParam.setAppId(config.getAppid());
        requestParam.setSecret(config.getSecret());
        requestParam.setGrantType("client_credential");
        requestParam.setForceRefresh(forceRefresh);
        String requestJson = JsonUtils.encode(requestParam);
        assert (requestJson != null);
        httpPost.setEntity((HttpEntity)new StringEntity(requestJson, ContentType.APPLICATION_JSON));
        return (String)this.getRequestHttpClient().execute((HttpUriRequest)httpPost, (ResponseHandler)ApacheBasicResponseHandler.INSTANCE);
    }
}

