/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.api.impl;

import me.chanjar.weixin.channel.api.WxLeagueProductService;
import me.chanjar.weixin.channel.api.impl.BaseWxChannelServiceImpl;
import me.chanjar.weixin.channel.bean.base.WxChannelBaseResponse;
import me.chanjar.weixin.channel.bean.league.product.BatchAddParam;
import me.chanjar.weixin.channel.bean.league.product.BatchAddResponse;
import me.chanjar.weixin.channel.bean.league.product.ProductDeleteParam;
import me.chanjar.weixin.channel.bean.league.product.ProductDetailParam;
import me.chanjar.weixin.channel.bean.league.product.ProductDetailResponse;
import me.chanjar.weixin.channel.bean.league.product.ProductListParam;
import me.chanjar.weixin.channel.bean.league.product.ProductListResponse;
import me.chanjar.weixin.channel.bean.league.product.ProductUpdateParam;
import me.chanjar.weixin.channel.bean.league.product.ProductUpdateResponse;
import me.chanjar.weixin.channel.util.ResponseUtils;
import me.chanjar.weixin.common.error.WxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxLeagueProductServiceImpl
implements WxLeagueProductService {
    private static final Logger log = LoggerFactory.getLogger(WxLeagueProductServiceImpl.class);
    private final BaseWxChannelServiceImpl<?, ?> shopService;

    public WxLeagueProductServiceImpl(BaseWxChannelServiceImpl<?, ?> shopService) {
        this.shopService = shopService;
    }

    @Override
    public BatchAddResponse batchAddProduct(BatchAddParam param) throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/league/item/batchadd", param);
        return ResponseUtils.decode(resJson, BatchAddResponse.class);
    }

    @Override
    public ProductUpdateResponse updateProduct(ProductUpdateParam param) throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/league/item/upd", param);
        return ResponseUtils.decode(resJson, ProductUpdateResponse.class);
    }

    @Override
    public WxChannelBaseResponse deleteProduct(Integer type, String productId, String infoId) throws WxErrorException {
        ProductDeleteParam param = new ProductDeleteParam(type, productId, infoId);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/league/item/delete", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public ProductDetailResponse getProductDetail(ProductDetailParam param) throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/league/item/get", param);
        return ResponseUtils.decode(resJson, ProductDetailResponse.class);
    }

    @Override
    public ProductListResponse listProduct(ProductListParam param) throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/league/item/list/get", param);
        return ResponseUtils.decode(resJson, ProductListResponse.class);
    }
}

