/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.bean;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Serializable;
import me.chanjar.weixin.common.bean.CommonUploadData;
import org.jetbrains.annotations.NotNull;
import org.springframework.lang.Nullable;

public class CommonUploadParam
implements Serializable {
    @NotNull
    private String name;
    @NotNull
    private CommonUploadData data;

    public static CommonUploadParam fromFile(String name, File file) {
        return new CommonUploadParam(name, CommonUploadData.fromFile(file));
    }

    public static CommonUploadParam fromBytes(String name, @Nullable String fileName, byte[] bytes) {
        return new CommonUploadParam(name, new CommonUploadData(fileName, new ByteArrayInputStream(bytes), bytes.length));
    }

    public String toString() {
        return String.format("{name:%s, data:%s}", this.name, this.data);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public CommonUploadData getData() {
        return this.data;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    public void setData(@NotNull CommonUploadData data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonUploadParam)) {
            return false;
        }
        CommonUploadParam other = (CommonUploadParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        CommonUploadData this$data = this.getData();
        CommonUploadData other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonUploadParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        CommonUploadData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public CommonUploadParam() {
    }

    public CommonUploadParam(@NotNull String name, @NotNull CommonUploadData data) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.name = name;
        this.data = data;
    }
}

