/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import me.chanjar.weixin.common.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.fs.FileUtils;
import me.chanjar.weixin.common.util.http.MediaDownloadRequestExecutor;
import me.chanjar.weixin.common.util.http.MediaUploadRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.cp.api.WxCpMediaService;
import me.chanjar.weixin.cp.api.WxCpService;

public class WxCpMediaServiceImpl
implements WxCpMediaService {
    private WxCpService mainService;

    public WxCpMediaServiceImpl(WxCpService mainService) {
        this.mainService = mainService;
    }

    @Override
    public WxMediaUploadResult upload(String mediaType, String fileType, InputStream inputStream) throws WxErrorException, IOException {
        return this.upload(mediaType, FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)fileType));
    }

    @Override
    public WxMediaUploadResult upload(String mediaType, File file) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/media/upload?type=" + mediaType;
        return (WxMediaUploadResult)this.mainService.execute(MediaUploadRequestExecutor.create((RequestHttp)this.mainService.getRequestHttp()), url, file);
    }

    @Override
    public File download(String mediaId) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/media/get";
        return (File)this.mainService.execute(MediaDownloadRequestExecutor.create((RequestHttp)this.mainService.getRequestHttp(), (File)this.mainService.getWxCpConfigStorage().getTmpDirFile()), url, "media_id=" + mediaId);
    }
}

